// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationResponseRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateIntegrationResponseOperationSerializer: HttpSerialize<CreateIntegrationResponseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateIntegrationResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
                "integrations",
                "${input.integrationId}".encodeLabel(),
                "integrationresponses",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateIntegrationResponseOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateIntegrationResponseOperationBody(context: ExecutionContext, input: CreateIntegrationResponseRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTHANDLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("contentHandlingStrategy"))
    val INTEGRATIONRESPONSEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseKey"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSETEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseTemplates"))
    val TEMPLATESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateSelectionExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR)
        field(INTEGRATIONRESPONSEKEY_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(RESPONSETEMPLATES_DESCRIPTOR)
        field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contentHandlingStrategy?.let { field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR, it.value) }
        input.integrationResponseKey?.let { field(INTEGRATIONRESPONSEKEY_DESCRIPTOR, it) }
        if (input.responseParameters != null) {
            mapField(RESPONSEPARAMETERS_DESCRIPTOR) {
                input.responseParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.responseTemplates != null) {
            mapField(RESPONSETEMPLATES_DESCRIPTOR) {
                input.responseTemplates.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.templateSelectionExpression?.let { field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
