// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewaymanagementapi.serde

import aws.sdk.kotlin.services.apigatewaymanagementapi.model.ApiGatewayManagementException
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.PostToConnectionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PostToConnectionOperationDeserializer: HttpDeserialize<PostToConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PostToConnectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostToConnectionError(context, call)
        }
        val builder = PostToConnectionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPostToConnectionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayManagementException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "PayloadTooLargeException" -> PayloadTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "GoneException" -> GoneExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayManagementException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
