// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.DomainNameStatus
import aws.sdk.kotlin.services.apigateway.model.SecurityPolicy
import aws.sdk.kotlin.services.apigateway.model.UpdateDomainNameResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateDomainNameOperationDeserializer: HttpDeserialize<UpdateDomainNameResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDomainNameResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDomainNameError(context, response)
        }
        val builder = UpdateDomainNameResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDomainNameOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeUpdateDomainNameOperationBody(builder: UpdateDomainNameResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateArn"))
    val CERTIFICATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateName"))
    val CERTIFICATEUPLOADDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("certificateUploadDate"))
    val DISTRIBUTIONDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("distributionDomainName"))
    val DISTRIBUTIONHOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("distributionHostedZoneId"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainName"))
    val DOMAINNAMESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameStatus"))
    val DOMAINNAMESTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainNameStatusMessage"))
    val ENDPOINTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("endpointConfiguration"))
    val MUTUALTLSAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mutualTlsAuthentication"))
    val OWNERSHIPVERIFICATIONCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownershipVerificationCertificateArn"))
    val REGIONALCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalCertificateArn"))
    val REGIONALCERTIFICATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalCertificateName"))
    val REGIONALDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalDomainName"))
    val REGIONALHOSTEDZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("regionalHostedZoneId"))
    val SECURITYPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("securityPolicy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATEARN_DESCRIPTOR)
        field(CERTIFICATENAME_DESCRIPTOR)
        field(CERTIFICATEUPLOADDATE_DESCRIPTOR)
        field(DISTRIBUTIONDOMAINNAME_DESCRIPTOR)
        field(DISTRIBUTIONHOSTEDZONEID_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINNAMESTATUS_DESCRIPTOR)
        field(DOMAINNAMESTATUSMESSAGE_DESCRIPTOR)
        field(ENDPOINTCONFIGURATION_DESCRIPTOR)
        field(MUTUALTLSAUTHENTICATION_DESCRIPTOR)
        field(OWNERSHIPVERIFICATIONCERTIFICATEARN_DESCRIPTOR)
        field(REGIONALCERTIFICATEARN_DESCRIPTOR)
        field(REGIONALCERTIFICATENAME_DESCRIPTOR)
        field(REGIONALDOMAINNAME_DESCRIPTOR)
        field(REGIONALHOSTEDZONEID_DESCRIPTOR)
        field(SECURITYPOLICY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATEARN_DESCRIPTOR.index -> builder.certificateArn = deserializeString()
                CERTIFICATENAME_DESCRIPTOR.index -> builder.certificateName = deserializeString()
                CERTIFICATEUPLOADDATE_DESCRIPTOR.index -> builder.certificateUploadDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISTRIBUTIONDOMAINNAME_DESCRIPTOR.index -> builder.distributionDomainName = deserializeString()
                DISTRIBUTIONHOSTEDZONEID_DESCRIPTOR.index -> builder.distributionHostedZoneId = deserializeString()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                DOMAINNAMESTATUS_DESCRIPTOR.index -> builder.domainNameStatus = deserializeString().let { DomainNameStatus.fromValue(it) }
                DOMAINNAMESTATUSMESSAGE_DESCRIPTOR.index -> builder.domainNameStatusMessage = deserializeString()
                ENDPOINTCONFIGURATION_DESCRIPTOR.index -> builder.endpointConfiguration = deserializeEndpointConfigurationDocument(deserializer)
                MUTUALTLSAUTHENTICATION_DESCRIPTOR.index -> builder.mutualTlsAuthentication = deserializeMutualTlsAuthenticationDocument(deserializer)
                OWNERSHIPVERIFICATIONCERTIFICATEARN_DESCRIPTOR.index -> builder.ownershipVerificationCertificateArn = deserializeString()
                REGIONALCERTIFICATEARN_DESCRIPTOR.index -> builder.regionalCertificateArn = deserializeString()
                REGIONALCERTIFICATENAME_DESCRIPTOR.index -> builder.regionalCertificateName = deserializeString()
                REGIONALDOMAINNAME_DESCRIPTOR.index -> builder.regionalDomainName = deserializeString()
                REGIONALHOSTEDZONEID_DESCRIPTOR.index -> builder.regionalHostedZoneId = deserializeString()
                SECURITYPOLICY_DESCRIPTOR.index -> builder.securityPolicy = deserializeString().let { SecurityPolicy.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateDomainNameError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
