// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.UpdateBasePathMappingResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBasePathMappingOperationDeserializer: HttpDeserialize<UpdateBasePathMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateBasePathMappingResponse {
        if (!response.status.isSuccess()) {
            throwUpdateBasePathMappingError(context, response)
        }
        val builder = UpdateBasePathMappingResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateBasePathMappingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeUpdateBasePathMappingOperationBody(builder: UpdateBasePathMappingResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basePath"))
    val RESTAPIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("restApiId"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEPATH_DESCRIPTOR)
        field(RESTAPIID_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEPATH_DESCRIPTOR.index -> builder.basePath = deserializeString()
                RESTAPIID_DESCRIPTOR.index -> builder.restApiId = deserializeString()
                STAGE_DESCRIPTOR.index -> builder.stage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateBasePathMappingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
