// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.AuthorizerType
import aws.sdk.kotlin.services.apigateway.model.UpdateAuthorizerResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAuthorizerOperationDeserializer: HttpDeserialize<UpdateAuthorizerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateAuthorizerResponse {
        if (!response.status.isSuccess()) {
            throwUpdateAuthorizerError(context, response)
        }
        val builder = UpdateAuthorizerResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateAuthorizerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeUpdateAuthorizerOperationBody(builder: UpdateAuthorizerResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authType"))
    val AUTHORIZERCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerCredentials"))
    val AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("authorizerResultTtlInSeconds"))
    val AUTHORIZERURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerUri"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val IDENTITYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identitySource"))
    val IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityValidationExpression"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROVIDERARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("providerARNs"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHTYPE_DESCRIPTOR)
        field(AUTHORIZERCREDENTIALS_DESCRIPTOR)
        field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR)
        field(AUTHORIZERURI_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(IDENTITYSOURCE_DESCRIPTOR)
        field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROVIDERARNS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHTYPE_DESCRIPTOR.index -> builder.authType = deserializeString()
                AUTHORIZERCREDENTIALS_DESCRIPTOR.index -> builder.authorizerCredentials = deserializeString()
                AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR.index -> builder.authorizerResultTtlInSeconds = deserializeInt()
                AUTHORIZERURI_DESCRIPTOR.index -> builder.authorizerUri = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                IDENTITYSOURCE_DESCRIPTOR.index -> builder.identitySource = deserializeString()
                IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR.index -> builder.identityValidationExpression = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROVIDERARNS_DESCRIPTOR.index -> builder.providerArNs =
                    deserializer.deserializeList(PROVIDERARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { AuthorizerType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateAuthorizerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
