// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestInvokeAuthorizerOperationDeserializer: HttpDeserialize<TestInvokeAuthorizerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TestInvokeAuthorizerResponse {
        if (!response.status.isSuccess()) {
            throwTestInvokeAuthorizerError(context, response)
        }
        val builder = TestInvokeAuthorizerResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTestInvokeAuthorizerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeTestInvokeAuthorizerOperationBody(builder: TestInvokeAuthorizerResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHORIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("authorization"))
    val AUTHORIZATION_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val CLAIMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("claims"))
    val CLIENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("clientStatus"))
    val LATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("latency"))
    val LOG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("log"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policy"))
    val PRINCIPALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("principalId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZATION_DESCRIPTOR)
        field(CLAIMS_DESCRIPTOR)
        field(CLIENTSTATUS_DESCRIPTOR)
        field(LATENCY_DESCRIPTOR)
        field(LOG_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
        field(PRINCIPALID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHORIZATION_DESCRIPTOR.index -> builder.authorization =
                    deserializer.deserializeMap(AUTHORIZATION_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(AUTHORIZATION_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<String>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                CLAIMS_DESCRIPTOR.index -> builder.claims =
                    deserializer.deserializeMap(CLAIMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CLIENTSTATUS_DESCRIPTOR.index -> builder.clientStatus = deserializeInt()
                LATENCY_DESCRIPTOR.index -> builder.latency = deserializeLong()
                LOG_DESCRIPTOR.index -> builder.log = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                PRINCIPALID_DESCRIPTOR.index -> builder.principalId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwTestInvokeAuthorizerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
