// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.ImportApiKeysResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportApiKeysOperationDeserializer: HttpDeserialize<ImportApiKeysResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ImportApiKeysResponse {
        if (!response.status.isSuccess()) {
            throwImportApiKeysError(context, response)
        }
        val builder = ImportApiKeysResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeImportApiKeysOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeImportApiKeysOperationBody(builder: ImportApiKeysResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ids"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDS_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDS_DESCRIPTOR.index -> builder.ids =
                    deserializer.deserializeList(IDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwImportApiKeysError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
