// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.CreateStageRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateStageOperationSerializer: HttpSerialize<CreateStageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateStageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "stages",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateStageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateStageOperationBody(context: ExecutionContext, input: CreateStageRequest): ByteArray {
    val serializer = JsonSerializer()
    val CACHECLUSTERENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("cacheClusterEnabled"))
    val CACHECLUSTERSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cacheClusterSize"))
    val CANARYSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("canarySettings"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOCUMENTATIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("documentationVersion"))
    val STAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stageName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TRACINGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("tracingEnabled"))
    val VARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("variables"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHECLUSTERENABLED_DESCRIPTOR)
        field(CACHECLUSTERSIZE_DESCRIPTOR)
        field(CANARYSETTINGS_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOCUMENTATIONVERSION_DESCRIPTOR)
        field(STAGENAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRACINGENABLED_DESCRIPTOR)
        field(VARIABLES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.cacheClusterEnabled != false) field(CACHECLUSTERENABLED_DESCRIPTOR, input.cacheClusterEnabled)
        input.cacheClusterSize?.let { field(CACHECLUSTERSIZE_DESCRIPTOR, it.value) }
        input.canarySettings?.let { field(CANARYSETTINGS_DESCRIPTOR, it, ::serializeCanarySettingsDocument) }
        input.deploymentId?.let { field(DEPLOYMENTID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.documentationVersion?.let { field(DOCUMENTATIONVERSION_DESCRIPTOR, it) }
        input.stageName?.let { field(STAGENAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.tracingEnabled != false) field(TRACINGENABLED_DESCRIPTOR, input.tracingEnabled)
        if (input.variables != null) {
            mapField(VARIABLES_DESCRIPTOR) {
                input.variables.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
