// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.CreateResourceResponse
import aws.sdk.kotlin.services.apigateway.model.Method
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateResourceOperationDeserializer: HttpDeserialize<CreateResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateResourceResponse {
        if (!response.status.isSuccess()) {
            throwCreateResourceError(context, response)
        }
        val builder = CreateResourceResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateResourceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateResourceOperationBody(builder: CreateResourceResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val PARENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentId"))
    val PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("path"))
    val PATHPART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pathPart"))
    val RESOURCEMETHODS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("resourceMethods"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ID_DESCRIPTOR)
        field(PARENTID_DESCRIPTOR)
        field(PATH_DESCRIPTOR)
        field(PATHPART_DESCRIPTOR)
        field(RESOURCEMETHODS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                PARENTID_DESCRIPTOR.index -> builder.parentId = deserializeString()
                PATH_DESCRIPTOR.index -> builder.path = deserializeString()
                PATHPART_DESCRIPTOR.index -> builder.pathPart = deserializeString()
                RESOURCEMETHODS_DESCRIPTOR.index -> builder.resourceMethods =
                    deserializer.deserializeMap(RESOURCEMETHODS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Method>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeMethodDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
