// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.CreateRequestValidatorResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRequestValidatorOperationDeserializer: HttpDeserialize<CreateRequestValidatorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateRequestValidatorResponse {
        if (!response.status.isSuccess()) {
            throwCreateRequestValidatorError(context, response)
        }
        val builder = CreateRequestValidatorResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateRequestValidatorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateRequestValidatorOperationBody(builder: CreateRequestValidatorResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val VALIDATEREQUESTBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("validateRequestBody"))
    val VALIDATEREQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("validateRequestParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(VALIDATEREQUESTBODY_DESCRIPTOR)
        field(VALIDATEREQUESTPARAMETERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                VALIDATEREQUESTBODY_DESCRIPTOR.index -> builder.validateRequestBody = deserializeBoolean()
                VALIDATEREQUESTPARAMETERS_DESCRIPTOR.index -> builder.validateRequestParameters = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateRequestValidatorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw ApiGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
