// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a usage plan key to identify a plan customer.
 * <div class="remarks">
 * To associate an API stage with a selected API key in a usage plan, you must create a UsagePlanKey resource to represent the selected ApiKey.
 * </div>"
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans
 * </div>
 */
class UsagePlanKey private constructor(builder: BuilderImpl) {
    /**
     * The Id of a usage plan key.
     */
    val id: String? = builder.id
    /**
     * The name of a usage plan key.
     */
    val name: String? = builder.name
    /**
     * The type of a usage plan key. Currently, the valid key type is API_KEY.
     */
    val type: String? = builder.type
    /**
     * The value of a usage plan key.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UsagePlanKey = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UsagePlanKey(")
        append("id=$id,")
        append("name=$name,")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UsagePlanKey

        if (id != other.id) return false
        if (name != other.name) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UsagePlanKey = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UsagePlanKey
        /**
         * The Id of a usage plan key.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of a usage plan key.
         */
        fun name(name: String): FluentBuilder
        /**
         * The type of a usage plan key. Currently, the valid key type is API_KEY.
         */
        fun type(type: String): FluentBuilder
        /**
         * The value of a usage plan key.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Id of a usage plan key.
         */
        var id: String?
        /**
         * The name of a usage plan key.
         */
        var name: String?
        /**
         * The type of a usage plan key. Currently, the valid key type is API_KEY.
         */
        var type: String?
        /**
         * The value of a usage plan key.
         */
        var value: String?

        fun build(): UsagePlanKey
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var id: String? = null
        override var name: String? = null
        override var type: String? = null
        override var value: String? = null

        constructor(x: UsagePlanKey) : this() {
            this.id = x.id
            this.name = x.name
            this.type = x.type
            this.value = x.value
        }

        override fun build(): UsagePlanKey = UsagePlanKey(this)
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
