// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the usage data of a usage plan.
 * <div class="remarks"></div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans,
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-usage-plans-with-console.html#api-gateway-usage-plan-manage-usage">Manage Usage in a Usage Plan
 * </div>
 */
class UpdateUsageResponse private constructor(builder: BuilderImpl) {
    /**
     * The ending date of the usage data.
     */
    val endDate: String? = builder.endDate
    /**
     * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, {..., "values" : { "{api_key}" : &#91; &#91;0, 100&#93;, &#91;10, 90&#93;, &#91;100, 10&#93;&#93;}, where {api_key} stands for an API key value and the daily log entry is of the format &#91;used quota, remaining quota&#93;.
     */
    val items: Map<String, List<List<Long>>>? = builder.items
    /**
     * The current pagination position in the paged result set.
     */
    val position: String? = builder.position
    /**
     * The starting date of the usage data.
     */
    val startDate: String? = builder.startDate
    /**
     * The plan Id associated with this usage data.
     */
    val usagePlanId: String? = builder.usagePlanId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateUsageResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUsageResponse(")
        append("endDate=$endDate,")
        append("items=$items,")
        append("position=$position,")
        append("startDate=$startDate,")
        append("usagePlanId=$usagePlanId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (usagePlanId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateUsageResponse

        if (endDate != other.endDate) return false
        if (items != other.items) return false
        if (position != other.position) return false
        if (startDate != other.startDate) return false
        if (usagePlanId != other.usagePlanId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateUsageResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateUsageResponse
        /**
         * The ending date of the usage data.
         */
        fun endDate(endDate: String): FluentBuilder
        /**
         * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, {..., "values" : { "{api_key}" : &#91; &#91;0, 100&#93;, &#91;10, 90&#93;, &#91;100, 10&#93;&#93;}, where {api_key} stands for an API key value and the daily log entry is of the format &#91;used quota, remaining quota&#93;.
         */
        fun items(items: Map<String, List<List<Long>>>): FluentBuilder
        /**
         * The current pagination position in the paged result set.
         */
        fun position(position: String): FluentBuilder
        /**
         * The starting date of the usage data.
         */
        fun startDate(startDate: String): FluentBuilder
        /**
         * The plan Id associated with this usage data.
         */
        fun usagePlanId(usagePlanId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ending date of the usage data.
         */
        var endDate: String?
        /**
         * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, {..., "values" : { "{api_key}" : &#91; &#91;0, 100&#93;, &#91;10, 90&#93;, &#91;100, 10&#93;&#93;}, where {api_key} stands for an API key value and the daily log entry is of the format &#91;used quota, remaining quota&#93;.
         */
        var items: Map<String, List<List<Long>>>?
        /**
         * The current pagination position in the paged result set.
         */
        var position: String?
        /**
         * The starting date of the usage data.
         */
        var startDate: String?
        /**
         * The plan Id associated with this usage data.
         */
        var usagePlanId: String?

        fun build(): UpdateUsageResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endDate: String? = null
        override var items: Map<String, List<List<Long>>>? = null
        override var position: String? = null
        override var startDate: String? = null
        override var usagePlanId: String? = null

        constructor(x: UpdateUsageResponse) : this() {
            this.endDate = x.endDate
            this.items = x.items
            this.position = x.position
            this.startDate = x.startDate
            this.usagePlanId = x.usagePlanId
        }

        override fun build(): UpdateUsageResponse = UpdateUsageResponse(this)
        override fun endDate(endDate: String): FluentBuilder = apply { this.endDate = endDate }
        override fun items(items: Map<String, List<List<Long>>>): FluentBuilder = apply { this.items = items }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
        override fun startDate(startDate: String): FluentBuilder = apply { this.startDate = startDate }
        override fun usagePlanId(usagePlanId: String): FluentBuilder = apply { this.usagePlanId = usagePlanId }
    }
}
