// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a unique identifier for a version of a deployed RestApi that is callable by users.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploy an API
 * </div>
 */
class UpdateStageResponse private constructor(builder: BuilderImpl) {
    /**
     * Settings for logging access in this stage.
     */
    val accessLogSettings: AccessLogSettings? = builder.accessLogSettings
    /**
     * Specifies whether a cache cluster is enabled for the stage.
     */
    val cacheClusterEnabled: Boolean = builder.cacheClusterEnabled
    /**
     * The size of the cache cluster for the stage, if enabled.
     */
    val cacheClusterSize: CacheClusterSize? = builder.cacheClusterSize
    /**
     * The status of the cache cluster for the stage, if enabled.
     */
    val cacheClusterStatus: CacheClusterStatus? = builder.cacheClusterStatus
    /**
     * Settings for the canary deployment in this stage.
     */
    val canarySettings: CanarySettings? = builder.canarySettings
    /**
     * The identifier of a client certificate for an API stage.
     */
    val clientCertificateId: String? = builder.clientCertificateId
    /**
     * The timestamp when the stage was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The identifier of the Deployment that the stage points to.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * The stage's description.
     */
    val description: String? = builder.description
    /**
     * The version of the associated API documentation.
     */
    val documentationVersion: String? = builder.documentationVersion
    /**
     * The timestamp when the stage last updated.
     */
    val lastUpdatedDate: Instant? = builder.lastUpdatedDate
    /**
     * A map that defines the method settings for a Stage resource. Keys (designated as /{method_setting_key below) are method paths defined as {resource_path}/{http_method} for an individual method override, or /\*&#47;\* for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the resource_path part must be encoded as "~1" as in, for example, ~1resource~1sub-resource/GET.-->
     */
    val methodSettings: Map<String, MethodSetting>? = builder.methodSettings
    /**
     * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
     */
    val stageName: String? = builder.stageName
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    val tracingEnabled: Boolean = builder.tracingEnabled
    /**
     * A map that defines the stage variables for a Stage resource. Variable names can
     * have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
     */
    val variables: Map<String, String>? = builder.variables
    /**
     * The ARN of the WebAcl associated with the Stage.
     */
    val webAclArn: String? = builder.webAclArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateStageResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStageResponse(")
        append("accessLogSettings=$accessLogSettings,")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("cacheClusterStatus=$cacheClusterStatus,")
        append("canarySettings=$canarySettings,")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("documentationVersion=$documentationVersion,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("methodSettings=$methodSettings,")
        append("stageName=$stageName,")
        append("tags=$tags,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables,")
        append("webAclArn=$webAclArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (cacheClusterEnabled.hashCode())
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterStatus?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentationVersion?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (methodSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled.hashCode())
        result = 31 * result + (variables?.hashCode() ?: 0)
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateStageResponse

        if (accessLogSettings != other.accessLogSettings) return false
        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (cacheClusterStatus != other.cacheClusterStatus) return false
        if (canarySettings != other.canarySettings) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (documentationVersion != other.documentationVersion) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (methodSettings != other.methodSettings) return false
        if (stageName != other.stageName) return false
        if (tags != other.tags) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false
        if (webAclArn != other.webAclArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateStageResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateStageResponse
        /**
         * Settings for logging access in this stage.
         */
        fun accessLogSettings(accessLogSettings: AccessLogSettings): FluentBuilder
        /**
         * Specifies whether a cache cluster is enabled for the stage.
         */
        fun cacheClusterEnabled(cacheClusterEnabled: Boolean): FluentBuilder
        /**
         * The size of the cache cluster for the stage, if enabled.
         */
        fun cacheClusterSize(cacheClusterSize: CacheClusterSize): FluentBuilder
        /**
         * The status of the cache cluster for the stage, if enabled.
         */
        fun cacheClusterStatus(cacheClusterStatus: CacheClusterStatus): FluentBuilder
        /**
         * Settings for the canary deployment in this stage.
         */
        fun canarySettings(canarySettings: CanarySettings): FluentBuilder
        /**
         * The identifier of a client certificate for an API stage.
         */
        fun clientCertificateId(clientCertificateId: String): FluentBuilder
        /**
         * The timestamp when the stage was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The identifier of the Deployment that the stage points to.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * The stage's description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The version of the associated API documentation.
         */
        fun documentationVersion(documentationVersion: String): FluentBuilder
        /**
         * The timestamp when the stage last updated.
         */
        fun lastUpdatedDate(lastUpdatedDate: Instant): FluentBuilder
        /**
         * A map that defines the method settings for a Stage resource. Keys (designated as /{method_setting_key below) are method paths defined as {resource_path}/{http_method} for an individual method override, or /\*&#47;\* for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the resource_path part must be encoded as "~1" as in, for example, ~1resource~1sub-resource/GET.-->
         */
        fun methodSettings(methodSettings: Map<String, MethodSetting>): FluentBuilder
        /**
         * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
         */
        fun stageName(stageName: String): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        fun tracingEnabled(tracingEnabled: Boolean): FluentBuilder
        /**
         * A map that defines the stage variables for a Stage resource. Variable names can
         * have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        fun variables(variables: Map<String, String>): FluentBuilder
        /**
         * The ARN of the WebAcl associated with the Stage.
         */
        fun webAclArn(webAclArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Settings for logging access in this stage.
         */
        var accessLogSettings: AccessLogSettings?
        /**
         * Specifies whether a cache cluster is enabled for the stage.
         */
        var cacheClusterEnabled: Boolean
        /**
         * The size of the cache cluster for the stage, if enabled.
         */
        var cacheClusterSize: CacheClusterSize?
        /**
         * The status of the cache cluster for the stage, if enabled.
         */
        var cacheClusterStatus: CacheClusterStatus?
        /**
         * Settings for the canary deployment in this stage.
         */
        var canarySettings: CanarySettings?
        /**
         * The identifier of a client certificate for an API stage.
         */
        var clientCertificateId: String?
        /**
         * The timestamp when the stage was created.
         */
        var createdDate: Instant?
        /**
         * The identifier of the Deployment that the stage points to.
         */
        var deploymentId: String?
        /**
         * The stage's description.
         */
        var description: String?
        /**
         * The version of the associated API documentation.
         */
        var documentationVersion: String?
        /**
         * The timestamp when the stage last updated.
         */
        var lastUpdatedDate: Instant?
        /**
         * A map that defines the method settings for a Stage resource. Keys (designated as /{method_setting_key below) are method paths defined as {resource_path}/{http_method} for an individual method override, or /\*&#47;\* for overriding all methods in the stage.  <!-- Any forward slash ("/") characters in the resource_path part must be encoded as "~1" as in, for example, ~1resource~1sub-resource/GET.-->
         */
        var methodSettings: Map<String, MethodSetting>?
        /**
         * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
         */
        var stageName: String?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        var tracingEnabled: Boolean
        /**
         * A map that defines the stage variables for a Stage resource. Variable names can
         * have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        var variables: Map<String, String>?
        /**
         * The ARN of the WebAcl associated with the Stage.
         */
        var webAclArn: String?

        fun build(): UpdateStageResponse
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.AccessLogSettings] inside the given [block]
         */
        fun accessLogSettings(block: AccessLogSettings.DslBuilder.() -> kotlin.Unit) {
            this.accessLogSettings = AccessLogSettings.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.CanarySettings] inside the given [block]
         */
        fun canarySettings(block: CanarySettings.DslBuilder.() -> kotlin.Unit) {
            this.canarySettings = CanarySettings.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessLogSettings: AccessLogSettings? = null
        override var cacheClusterEnabled: Boolean = false
        override var cacheClusterSize: CacheClusterSize? = null
        override var cacheClusterStatus: CacheClusterStatus? = null
        override var canarySettings: CanarySettings? = null
        override var clientCertificateId: String? = null
        override var createdDate: Instant? = null
        override var deploymentId: String? = null
        override var description: String? = null
        override var documentationVersion: String? = null
        override var lastUpdatedDate: Instant? = null
        override var methodSettings: Map<String, MethodSetting>? = null
        override var stageName: String? = null
        override var tags: Map<String, String>? = null
        override var tracingEnabled: Boolean = false
        override var variables: Map<String, String>? = null
        override var webAclArn: String? = null

        constructor(x: UpdateStageResponse) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.cacheClusterStatus = x.cacheClusterStatus
            this.canarySettings = x.canarySettings
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.documentationVersion = x.documentationVersion
            this.lastUpdatedDate = x.lastUpdatedDate
            this.methodSettings = x.methodSettings
            this.stageName = x.stageName
            this.tags = x.tags
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
            this.webAclArn = x.webAclArn
        }

        override fun build(): UpdateStageResponse = UpdateStageResponse(this)
        override fun accessLogSettings(accessLogSettings: AccessLogSettings): FluentBuilder = apply { this.accessLogSettings = accessLogSettings }
        override fun cacheClusterEnabled(cacheClusterEnabled: Boolean): FluentBuilder = apply { this.cacheClusterEnabled = cacheClusterEnabled }
        override fun cacheClusterSize(cacheClusterSize: CacheClusterSize): FluentBuilder = apply { this.cacheClusterSize = cacheClusterSize }
        override fun cacheClusterStatus(cacheClusterStatus: CacheClusterStatus): FluentBuilder = apply { this.cacheClusterStatus = cacheClusterStatus }
        override fun canarySettings(canarySettings: CanarySettings): FluentBuilder = apply { this.canarySettings = canarySettings }
        override fun clientCertificateId(clientCertificateId: String): FluentBuilder = apply { this.clientCertificateId = clientCertificateId }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun documentationVersion(documentationVersion: String): FluentBuilder = apply { this.documentationVersion = documentationVersion }
        override fun lastUpdatedDate(lastUpdatedDate: Instant): FluentBuilder = apply { this.lastUpdatedDate = lastUpdatedDate }
        override fun methodSettings(methodSettings: Map<String, MethodSetting>): FluentBuilder = apply { this.methodSettings = methodSettings }
        override fun stageName(stageName: String): FluentBuilder = apply { this.stageName = stageName }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun tracingEnabled(tracingEnabled: Boolean): FluentBuilder = apply { this.tracingEnabled = tracingEnabled }
        override fun variables(variables: Map<String, String>): FluentBuilder = apply { this.variables = variables }
        override fun webAclArn(webAclArn: String): FluentBuilder = apply { this.webAclArn = webAclArn }
    }
}
