// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A gateway response of a given response type and status code, with optional response parameters and mapping templates.
 * <div class="remarks">
 * For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway
 * <div class="example">
 * <h4>Example: Get a Gateway Response of a given response type</h4>
 * <h5>Request</h5>
 * This example shows how to get a gateway response of the MISSING_AUTHENTICATION_TOKEN type.
 * <pre>GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
 * Host: beta-apigateway.us-east-1.amazonaws.com
 * Content-Type: application/json
 * X-Amz-Date: 20170503T202516Z
 * Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
 * Cache-Control: no-cache
 * Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
 * </pre>
 * The response type is specified as a URL path.
 * <h5>Response</h5>
 * The successful operation returns the 200 OK status code and a payload similar to the following:
 * <pre>{
 * "_links": {
 * "curies": {
 * "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
 * "name": "gatewayresponse",
 * "templated": true
 * },
 * "self": {
 * "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
 * },
 * "gatewayresponse:delete": {
 * "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
 * },
 * "gatewayresponse:put": {
 * "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
 * "templated": true
 * },
 * "gatewayresponse:update": {
 * "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
 * }
 * },
 * "defaultResponse": false,
 * "responseParameters": {
 * "gatewayresponse.header.x-request-path": "method.request.path.petId",
 * "gatewayresponse.header.Access-Control-Allow-Origin": "'a.b.c'",
 * "gatewayresponse.header.x-request-query": "method.request.querystring.q",
 * "gatewayresponse.header.x-request-header": "method.request.header.Accept"
 * },
 * "responseTemplates": {
 * "application/json": "{\n     \"message\": $context.error.messageString,\n     \"type\":  \"$context.error.responseType\",\n     \"stage\":  \"$context.stage\",\n     \"resourcePath\":  \"$context.resourcePath\",\n     \"stageVariables.a\":  \"$stageVariables.a\",\n     \"statusCode\": \"'404'\"\n}"
 * },
 * "responseType": "MISSING_AUTHENTICATION_TOKEN",
 * "statusCode": "404"
 * }</pre>
 * </div>
 * </div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses
 * </div>
 */
class UpdateGatewayResponseResponse private constructor(builder: BuilderImpl) {
    /**
     * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (true) or not (false). A default gateway response is one generated by API Gateway without any customization by an API developer.
     */
    val defaultResponse: Boolean = builder.defaultResponse
    /**
     * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value  pairs.
     */
    val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * The response type of the associated GatewayResponse.
     */
    val responseType: GatewayResponseType? = builder.responseType
    /**
     * The HTTP status code for this GatewayResponse.
     */
    val statusCode: String? = builder.statusCode

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateGatewayResponseResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGatewayResponseResponse(")
        append("defaultResponse=$defaultResponse,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("responseType=$responseType,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultResponse.hashCode()
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (responseType?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateGatewayResponseResponse

        if (defaultResponse != other.defaultResponse) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (responseType != other.responseType) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateGatewayResponseResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateGatewayResponseResponse
        /**
         * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (true) or not (false). A default gateway response is one generated by API Gateway without any customization by an API developer.
         */
        fun defaultResponse(defaultResponse: Boolean): FluentBuilder
        /**
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value  pairs.
         */
        fun responseParameters(responseParameters: Map<String, String>): FluentBuilder
        /**
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        fun responseTemplates(responseTemplates: Map<String, String>): FluentBuilder
        /**
         * The response type of the associated GatewayResponse.
         */
        fun responseType(responseType: GatewayResponseType): FluentBuilder
        /**
         * The HTTP status code for this GatewayResponse.
         */
        fun statusCode(statusCode: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean flag to indicate whether this GatewayResponse is the default gateway response (true) or not (false). A default gateway response is one generated by API Gateway without any customization by an API developer.
         */
        var defaultResponse: Boolean
        /**
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value  pairs.
         */
        var responseParameters: Map<String, String>?
        /**
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        var responseTemplates: Map<String, String>?
        /**
         * The response type of the associated GatewayResponse.
         */
        var responseType: GatewayResponseType?
        /**
         * The HTTP status code for this GatewayResponse.
         */
        var statusCode: String?

        fun build(): UpdateGatewayResponseResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var defaultResponse: Boolean = false
        override var responseParameters: Map<String, String>? = null
        override var responseTemplates: Map<String, String>? = null
        override var responseType: GatewayResponseType? = null
        override var statusCode: String? = null

        constructor(x: UpdateGatewayResponseResponse) : this() {
            this.defaultResponse = x.defaultResponse
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.responseType = x.responseType
            this.statusCode = x.statusCode
        }

        override fun build(): UpdateGatewayResponseResponse = UpdateGatewayResponseResponse(this)
        override fun defaultResponse(defaultResponse: Boolean): FluentBuilder = apply { this.defaultResponse = defaultResponse }
        override fun responseParameters(responseParameters: Map<String, String>): FluentBuilder = apply { this.responseParameters = responseParameters }
        override fun responseTemplates(responseTemplates: Map<String, String>): FluentBuilder = apply { this.responseTemplates = responseTemplates }
        override fun responseType(responseType: GatewayResponseType): FluentBuilder = apply { this.responseType = responseType }
        override fun statusCode(statusCode: String): FluentBuilder = apply { this.statusCode = statusCode }
    }
}
