// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a custom domain name as a user-friendly host name of an API (RestApi).
 * <div class="Remarks">
 * When you deploy an API, API Gateway creates a default host name for the API. This default API host name is of the {restapi-id}.execute-api.{region}.amazonaws.com format. With the default host name, you can access the API's root resource with the URL of https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/. When you set up a custom domain name of apis.example.com for this API, you can then access the same resource using the URL of the https://apis.examples.com/myApi, where myApi is the base path mapping (BasePathMapping) of your API under the custom domain name.
 * </div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set a Custom Host Name for an API
 * </div>
 */
class UpdateDomainNameResponse private constructor(builder: BuilderImpl) {
    /**
     * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
     */
    val certificateName: String? = builder.certificateName
    /**
     * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
     */
    val certificateUploadDate: Instant? = builder.certificateUploadDate
    /**
     * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation.
     */
    val distributionDomainName: String? = builder.distributionDomainName
    /**
     * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is Z2FDTNDATAQYW2 for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway.
     */
    val distributionHostedZoneId: String? = builder.distributionHostedZoneId
    /**
     * The custom domain name as an API host name, for example, my-api.example.com.
     */
    val domainName: String? = builder.domainName
    /**
     * The status of the DomainName migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.
     */
    val domainNameStatus: DomainNameStatus? = builder.domainNameStatus
    /**
     * An optional text message containing detailed information about status of the DomainName migration.
     */
    val domainNameStatusMessage: String? = builder.domainNameStatusMessage
    /**
     * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
     */
    val endpointConfiguration: EndpointConfiguration? = builder.endpointConfiguration
    /**
     * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
     */
    val mutualTlsAuthentication: MutualTlsAuthentication? = builder.mutualTlsAuthentication
    /**
     * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
     */
    val ownershipVerificationCertificateArn: String? = builder.ownershipVerificationCertificateArn
    /**
     * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.
     */
    val regionalCertificateArn: String? = builder.regionalCertificateArn
    /**
     * The name of the certificate that will be used for validating the regional domain name.
     */
    val regionalCertificateName: String? = builder.regionalCertificateName
    /**
     * The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.
     */
    val regionalDomainName: String? = builder.regionalDomainName
    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway.
     */
    val regionalHostedZoneId: String? = builder.regionalHostedZoneId
    /**
     * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2.
     */
    val securityPolicy: SecurityPolicy? = builder.securityPolicy
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateDomainNameResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainNameResponse(")
        append("certificateArn=$certificateArn,")
        append("certificateName=$certificateName,")
        append("certificateUploadDate=$certificateUploadDate,")
        append("distributionDomainName=$distributionDomainName,")
        append("distributionHostedZoneId=$distributionHostedZoneId,")
        append("domainName=$domainName,")
        append("domainNameStatus=$domainNameStatus,")
        append("domainNameStatusMessage=$domainNameStatusMessage,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("mutualTlsAuthentication=$mutualTlsAuthentication,")
        append("ownershipVerificationCertificateArn=$ownershipVerificationCertificateArn,")
        append("regionalCertificateArn=$regionalCertificateArn,")
        append("regionalCertificateName=$regionalCertificateName,")
        append("regionalDomainName=$regionalDomainName,")
        append("regionalHostedZoneId=$regionalHostedZoneId,")
        append("securityPolicy=$securityPolicy,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (certificateUploadDate?.hashCode() ?: 0)
        result = 31 * result + (distributionDomainName?.hashCode() ?: 0)
        result = 31 * result + (distributionHostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainNameStatus?.hashCode() ?: 0)
        result = 31 * result + (domainNameStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mutualTlsAuthentication?.hashCode() ?: 0)
        result = 31 * result + (ownershipVerificationCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateName?.hashCode() ?: 0)
        result = 31 * result + (regionalDomainName?.hashCode() ?: 0)
        result = 31 * result + (regionalHostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (securityPolicy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateDomainNameResponse

        if (certificateArn != other.certificateArn) return false
        if (certificateName != other.certificateName) return false
        if (certificateUploadDate != other.certificateUploadDate) return false
        if (distributionDomainName != other.distributionDomainName) return false
        if (distributionHostedZoneId != other.distributionHostedZoneId) return false
        if (domainName != other.domainName) return false
        if (domainNameStatus != other.domainNameStatus) return false
        if (domainNameStatusMessage != other.domainNameStatusMessage) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (mutualTlsAuthentication != other.mutualTlsAuthentication) return false
        if (ownershipVerificationCertificateArn != other.ownershipVerificationCertificateArn) return false
        if (regionalCertificateArn != other.regionalCertificateArn) return false
        if (regionalCertificateName != other.regionalCertificateName) return false
        if (regionalDomainName != other.regionalDomainName) return false
        if (regionalHostedZoneId != other.regionalHostedZoneId) return false
        if (securityPolicy != other.securityPolicy) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateDomainNameResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateDomainNameResponse
        /**
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
         */
        fun certificateName(certificateName: String): FluentBuilder
        /**
         * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
         */
        fun certificateUploadDate(certificateUploadDate: Instant): FluentBuilder
        /**
         * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation.
         */
        fun distributionDomainName(distributionDomainName: String): FluentBuilder
        /**
         * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is Z2FDTNDATAQYW2 for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway.
         */
        fun distributionHostedZoneId(distributionHostedZoneId: String): FluentBuilder
        /**
         * The custom domain name as an API host name, for example, my-api.example.com.
         */
        fun domainName(domainName: String): FluentBuilder
        /**
         * The status of the DomainName migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.
         */
        fun domainNameStatus(domainNameStatus: DomainNameStatus): FluentBuilder
        /**
         * An optional text message containing detailed information about status of the DomainName migration.
         */
        fun domainNameStatusMessage(domainNameStatusMessage: String): FluentBuilder
        /**
         * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         */
        fun endpointConfiguration(endpointConfiguration: EndpointConfiguration): FluentBuilder
        /**
         * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
         */
        fun mutualTlsAuthentication(mutualTlsAuthentication: MutualTlsAuthentication): FluentBuilder
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
         */
        fun ownershipVerificationCertificateArn(ownershipVerificationCertificateArn: String): FluentBuilder
        /**
         * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.
         */
        fun regionalCertificateArn(regionalCertificateArn: String): FluentBuilder
        /**
         * The name of the certificate that will be used for validating the regional domain name.
         */
        fun regionalCertificateName(regionalCertificateName: String): FluentBuilder
        /**
         * The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.
         */
        fun regionalDomainName(regionalDomainName: String): FluentBuilder
        /**
         * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway.
         */
        fun regionalHostedZoneId(regionalHostedZoneId: String): FluentBuilder
        /**
         * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2.
         */
        fun securityPolicy(securityPolicy: SecurityPolicy): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        var certificateArn: String?
        /**
         * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
         */
        var certificateName: String?
        /**
         * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
         */
        var certificateUploadDate: Instant?
        /**
         * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a target="_blank" href="https://aws.amazon.com/documentation/cloudfront/">Amazon CloudFront documentation.
         */
        var distributionDomainName: String?
        /**
         * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is Z2FDTNDATAQYW2 for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway.
         */
        var distributionHostedZoneId: String?
        /**
         * The custom domain name as an API host name, for example, my-api.example.com.
         */
        var domainName: String?
        /**
         * The status of the DomainName migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.
         */
        var domainNameStatus: DomainNameStatus?
        /**
         * An optional text message containing detailed information about status of the DomainName migration.
         */
        var domainNameStatusMessage: String?
        /**
         * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         */
        var endpointConfiguration: EndpointConfiguration?
        /**
         * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
         */
        var mutualTlsAuthentication: MutualTlsAuthentication?
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
         */
        var ownershipVerificationCertificateArn: String?
        /**
         * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.
         */
        var regionalCertificateArn: String?
        /**
         * The name of the certificate that will be used for validating the regional domain name.
         */
        var regionalCertificateName: String?
        /**
         * The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.
         */
        var regionalDomainName: String?
        /**
         * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name and  <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway.
         */
        var regionalHostedZoneId: String?
        /**
         * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2.
         */
        var securityPolicy: SecurityPolicy?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?

        fun build(): UpdateDomainNameResponse
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        fun endpointConfiguration(block: EndpointConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.endpointConfiguration = EndpointConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication] inside the given [block]
         */
        fun mutualTlsAuthentication(block: MutualTlsAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.mutualTlsAuthentication = MutualTlsAuthentication.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var certificateName: String? = null
        override var certificateUploadDate: Instant? = null
        override var distributionDomainName: String? = null
        override var distributionHostedZoneId: String? = null
        override var domainName: String? = null
        override var domainNameStatus: DomainNameStatus? = null
        override var domainNameStatusMessage: String? = null
        override var endpointConfiguration: EndpointConfiguration? = null
        override var mutualTlsAuthentication: MutualTlsAuthentication? = null
        override var ownershipVerificationCertificateArn: String? = null
        override var regionalCertificateArn: String? = null
        override var regionalCertificateName: String? = null
        override var regionalDomainName: String? = null
        override var regionalHostedZoneId: String? = null
        override var securityPolicy: SecurityPolicy? = null
        override var tags: Map<String, String>? = null

        constructor(x: UpdateDomainNameResponse) : this() {
            this.certificateArn = x.certificateArn
            this.certificateName = x.certificateName
            this.certificateUploadDate = x.certificateUploadDate
            this.distributionDomainName = x.distributionDomainName
            this.distributionHostedZoneId = x.distributionHostedZoneId
            this.domainName = x.domainName
            this.domainNameStatus = x.domainNameStatus
            this.domainNameStatusMessage = x.domainNameStatusMessage
            this.endpointConfiguration = x.endpointConfiguration
            this.mutualTlsAuthentication = x.mutualTlsAuthentication
            this.ownershipVerificationCertificateArn = x.ownershipVerificationCertificateArn
            this.regionalCertificateArn = x.regionalCertificateArn
            this.regionalCertificateName = x.regionalCertificateName
            this.regionalDomainName = x.regionalDomainName
            this.regionalHostedZoneId = x.regionalHostedZoneId
            this.securityPolicy = x.securityPolicy
            this.tags = x.tags
        }

        override fun build(): UpdateDomainNameResponse = UpdateDomainNameResponse(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun certificateName(certificateName: String): FluentBuilder = apply { this.certificateName = certificateName }
        override fun certificateUploadDate(certificateUploadDate: Instant): FluentBuilder = apply { this.certificateUploadDate = certificateUploadDate }
        override fun distributionDomainName(distributionDomainName: String): FluentBuilder = apply { this.distributionDomainName = distributionDomainName }
        override fun distributionHostedZoneId(distributionHostedZoneId: String): FluentBuilder = apply { this.distributionHostedZoneId = distributionHostedZoneId }
        override fun domainName(domainName: String): FluentBuilder = apply { this.domainName = domainName }
        override fun domainNameStatus(domainNameStatus: DomainNameStatus): FluentBuilder = apply { this.domainNameStatus = domainNameStatus }
        override fun domainNameStatusMessage(domainNameStatusMessage: String): FluentBuilder = apply { this.domainNameStatusMessage = domainNameStatusMessage }
        override fun endpointConfiguration(endpointConfiguration: EndpointConfiguration): FluentBuilder = apply { this.endpointConfiguration = endpointConfiguration }
        override fun mutualTlsAuthentication(mutualTlsAuthentication: MutualTlsAuthentication): FluentBuilder = apply { this.mutualTlsAuthentication = mutualTlsAuthentication }
        override fun ownershipVerificationCertificateArn(ownershipVerificationCertificateArn: String): FluentBuilder = apply { this.ownershipVerificationCertificateArn = ownershipVerificationCertificateArn }
        override fun regionalCertificateArn(regionalCertificateArn: String): FluentBuilder = apply { this.regionalCertificateArn = regionalCertificateArn }
        override fun regionalCertificateName(regionalCertificateName: String): FluentBuilder = apply { this.regionalCertificateName = regionalCertificateName }
        override fun regionalDomainName(regionalDomainName: String): FluentBuilder = apply { this.regionalDomainName = regionalDomainName }
        override fun regionalHostedZoneId(regionalHostedZoneId: String): FluentBuilder = apply { this.regionalHostedZoneId = regionalHostedZoneId }
        override fun securityPolicy(securityPolicy: SecurityPolicy): FluentBuilder = apply { this.securityPolicy = securityPolicy }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
