// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A snapshot of the documentation of an API.
 * <div class="remarks">Publishing API documentation involves creating a documentation version associated with an API stage and exporting the versioned documentation to an external (e.g., OpenAPI) file.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API, DocumentationPart, DocumentationVersions
 * </div>
 */
class UpdateDocumentationVersionResponse private constructor(builder: BuilderImpl) {
    /**
     * The date when the API documentation snapshot is created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The description of the API documentation snapshot.
     */
    val description: String? = builder.description
    /**
     * The version identifier of the API documentation snapshot.
     */
    val version: String? = builder.version

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateDocumentationVersionResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDocumentationVersionResponse(")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateDocumentationVersionResponse

        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (version != other.version) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateDocumentationVersionResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateDocumentationVersionResponse
        /**
         * The date when the API documentation snapshot is created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The description of the API documentation snapshot.
         */
        fun description(description: String): FluentBuilder
        /**
         * The version identifier of the API documentation snapshot.
         */
        fun version(version: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date when the API documentation snapshot is created.
         */
        var createdDate: Instant?
        /**
         * The description of the API documentation snapshot.
         */
        var description: String?
        /**
         * The version identifier of the API documentation snapshot.
         */
        var version: String?

        fun build(): UpdateDocumentationVersionResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdDate: Instant? = null
        override var description: String? = null
        override var version: String? = null

        constructor(x: UpdateDocumentationVersionResponse) : this() {
            this.createdDate = x.createdDate
            this.description = x.description
            this.version = x.version
        }

        override fun build(): UpdateDocumentationVersionResponse = UpdateDocumentationVersionResponse(this)
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
    }
}
