// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer
 * </div>
 */
class UpdateAuthorizerResponse private constructor(builder: BuilderImpl) {
    /**
     * Optional customer-defined field, used in OpenAPI imports and exports without functional impact.
     */
    val authType: String? = builder.authType
    /**
     * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
     */
    val authorizerCredentials: String? = builder.authorizerCredentials
    /**
     * The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.
     */
    val authorizerResultTtlInSeconds: Int? = builder.authorizerResultTtlInSeconds
    /**
     * Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form  arn:aws:apigateway:{region}:lambda:path/{service_api}, where {region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/&#91;FunctionARN&#93;/invocations.
     */
    val authorizerUri: String? = builder.authorizerUri
    /**
     * The identifier for the authorizer resource.
     */
    val id: String? = builder.id
    /**
     * The identity source for which authorization is requested. For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is Auth, the header mapping expression is  method.request.header.Auth.For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an Auth header, a Name query string parameter are defined as identity sources, this value is method.request.header.Auth, method.request.querystring.Name.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.
     */
    val identitySource: String? = builder.identitySource
    /**
     * A validation expression for the incoming identity token. For TOKEN authorizers, this value is a regular expression. For COGNITO_USER_POOLS authorizers, API Gateway will match the aud field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the REQUEST authorizer.
     */
    val identityValidationExpression: String? = builder.identityValidationExpression
    /**
     * &#91;Required&#93; The name of the authorizer.
     */
    val name: String? = builder.name
    /**
     * A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer. Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}. For a TOKEN or REQUEST authorizer, this is not defined.
     */
    val providerArNs: List<String>? = builder.providerArNs
    /**
     * The authorizer type. Valid values are TOKEN for a Lambda function using a single authorization token submitted in a custom header, REQUEST for a Lambda function using incoming request parameters, and COGNITO_USER_POOLS for using an Amazon Cognito user pool.
     */
    val type: AuthorizerType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateAuthorizerResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAuthorizerResponse(")
        append("authType=$authType,")
        append("authorizerCredentials=$authorizerCredentials,")
        append("authorizerResultTtlInSeconds=$authorizerResultTtlInSeconds,")
        append("authorizerUri=$authorizerUri,")
        append("id=$id,")
        append("identitySource=$identitySource,")
        append("identityValidationExpression=$identityValidationExpression,")
        append("name=$name,")
        append("providerArNs=$providerArNs,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (authorizerCredentials?.hashCode() ?: 0)
        result = 31 * result + (authorizerResultTtlInSeconds ?: 0)
        result = 31 * result + (authorizerUri?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (identitySource?.hashCode() ?: 0)
        result = 31 * result + (identityValidationExpression?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (providerArNs?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateAuthorizerResponse

        if (authType != other.authType) return false
        if (authorizerCredentials != other.authorizerCredentials) return false
        if (authorizerResultTtlInSeconds != other.authorizerResultTtlInSeconds) return false
        if (authorizerUri != other.authorizerUri) return false
        if (id != other.id) return false
        if (identitySource != other.identitySource) return false
        if (identityValidationExpression != other.identityValidationExpression) return false
        if (name != other.name) return false
        if (providerArNs != other.providerArNs) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateAuthorizerResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateAuthorizerResponse
        /**
         * Optional customer-defined field, used in OpenAPI imports and exports without functional impact.
         */
        fun authType(authType: String): FluentBuilder
        /**
         * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
         */
        fun authorizerCredentials(authorizerCredentials: String): FluentBuilder
        /**
         * The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.
         */
        fun authorizerResultTtlInSeconds(authorizerResultTtlInSeconds: Int): FluentBuilder
        /**
         * Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form  arn:aws:apigateway:{region}:lambda:path/{service_api}, where {region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/&#91;FunctionARN&#93;/invocations.
         */
        fun authorizerUri(authorizerUri: String): FluentBuilder
        /**
         * The identifier for the authorizer resource.
         */
        fun id(id: String): FluentBuilder
        /**
         * The identity source for which authorization is requested. For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is Auth, the header mapping expression is  method.request.header.Auth.For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an Auth header, a Name query string parameter are defined as identity sources, this value is method.request.header.Auth, method.request.querystring.Name.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.
         */
        fun identitySource(identitySource: String): FluentBuilder
        /**
         * A validation expression for the incoming identity token. For TOKEN authorizers, this value is a regular expression. For COGNITO_USER_POOLS authorizers, API Gateway will match the aud field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the REQUEST authorizer.
         */
        fun identityValidationExpression(identityValidationExpression: String): FluentBuilder
        /**
         * &#91;Required&#93; The name of the authorizer.
         */
        fun name(name: String): FluentBuilder
        /**
         * A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer. Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}. For a TOKEN or REQUEST authorizer, this is not defined.
         */
        fun providerArNs(providerArNs: List<String>): FluentBuilder
        /**
         * The authorizer type. Valid values are TOKEN for a Lambda function using a single authorization token submitted in a custom header, REQUEST for a Lambda function using incoming request parameters, and COGNITO_USER_POOLS for using an Amazon Cognito user pool.
         */
        fun type(type: AuthorizerType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Optional customer-defined field, used in OpenAPI imports and exports without functional impact.
         */
        var authType: String?
        /**
         * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
         */
        var authorizerCredentials: String?
        /**
         * The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.
         */
        var authorizerResultTtlInSeconds: Int?
        /**
         * Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form  arn:aws:apigateway:{region}:lambda:path/{service_api}, where {region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/&#91;FunctionARN&#93;/invocations.
         */
        var authorizerUri: String?
        /**
         * The identifier for the authorizer resource.
         */
        var id: String?
        /**
         * The identity source for which authorization is requested. For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is Auth, the header mapping expression is  method.request.header.Auth.For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an Auth header, a Name query string parameter are defined as identity sources, this value is method.request.header.Auth, method.request.querystring.Name.  These parameters will be used to derive the authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.
         */
        var identitySource: String?
        /**
         * A validation expression for the incoming identity token. For TOKEN authorizers, this value is a regular expression. For COGNITO_USER_POOLS authorizers, API Gateway will match the aud field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the REQUEST authorizer.
         */
        var identityValidationExpression: String?
        /**
         * &#91;Required&#93; The name of the authorizer.
         */
        var name: String?
        /**
         * A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer. Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}. For a TOKEN or REQUEST authorizer, this is not defined.
         */
        var providerArNs: List<String>?
        /**
         * The authorizer type. Valid values are TOKEN for a Lambda function using a single authorization token submitted in a custom header, REQUEST for a Lambda function using incoming request parameters, and COGNITO_USER_POOLS for using an Amazon Cognito user pool.
         */
        var type: AuthorizerType?

        fun build(): UpdateAuthorizerResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authType: String? = null
        override var authorizerCredentials: String? = null
        override var authorizerResultTtlInSeconds: Int? = null
        override var authorizerUri: String? = null
        override var id: String? = null
        override var identitySource: String? = null
        override var identityValidationExpression: String? = null
        override var name: String? = null
        override var providerArNs: List<String>? = null
        override var type: AuthorizerType? = null

        constructor(x: UpdateAuthorizerResponse) : this() {
            this.authType = x.authType
            this.authorizerCredentials = x.authorizerCredentials
            this.authorizerResultTtlInSeconds = x.authorizerResultTtlInSeconds
            this.authorizerUri = x.authorizerUri
            this.id = x.id
            this.identitySource = x.identitySource
            this.identityValidationExpression = x.identityValidationExpression
            this.name = x.name
            this.providerArNs = x.providerArNs
            this.type = x.type
        }

        override fun build(): UpdateAuthorizerResponse = UpdateAuthorizerResponse(this)
        override fun authType(authType: String): FluentBuilder = apply { this.authType = authType }
        override fun authorizerCredentials(authorizerCredentials: String): FluentBuilder = apply { this.authorizerCredentials = authorizerCredentials }
        override fun authorizerResultTtlInSeconds(authorizerResultTtlInSeconds: Int): FluentBuilder = apply { this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds }
        override fun authorizerUri(authorizerUri: String): FluentBuilder = apply { this.authorizerUri = authorizerUri }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun identitySource(identitySource: String): FluentBuilder = apply { this.identitySource = identitySource }
        override fun identityValidationExpression(identityValidationExpression: String): FluentBuilder = apply { this.identityValidationExpression = identityValidationExpression }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun providerArNs(providerArNs: List<String>): FluentBuilder = apply { this.providerArNs = providerArNs }
        override fun type(type: AuthorizerType): FluentBuilder = apply { this.type = type }
    }
}
