// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an AWS account that is associated with API Gateway.
 * <div class="remarks">
 * To view the account info, call GET on this resource.
 * <h4>Error Codes</h4>
 * The following exception may be thrown when the request fails.
 * UnauthorizedException
 * NotFoundException
 * TooManyRequestsException
 * For detailed error code information, including the corresponding HTTP Status Codes, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/handling-errors/#api-error-codes">API Gateway Error Codes
 * <h4>Example: Get the information about an account.</h4>
 * <h5>Request</h5>
 * <pre>GET /account HTTP/1.1
 * Content-Type: application/json
 * Host: apigateway.us-east-1.amazonaws.com
 * X-Amz-Date: 20160531T184618Z
 * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
 * </pre>
 * <h5>Response</h5>
 * The successful response returns a 200 OK status code and a payload similar to the following:
 * <pre>{
 * "_links": {
 * "curies": {
 * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/account-apigateway-{rel}.html",
 * "name": "account",
 * "templated": true
 * },
 * "self": {
 * "href": "/account"
 * },
 * "account:update": {
 * "href": "/account"
 * }
 * },
 * "cloudwatchRoleArn": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
 * "throttleSettings": {
 * "rateLimit": 500,
 * "burstLimit": 1000
 * }
 * }
 * </pre>
 * In addition to making the REST API call directly, you can use the AWS CLI and an AWS SDK to access this resource.
 * </div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-limits.html">API Gateway Limits
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/welcome.html">Developer Guide,
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-account.html">AWS CLI
 * </div>
 */
class UpdateAccountResponse private constructor(builder: BuilderImpl) {
    /**
     * The version of the API keys used for the account.
     */
    val apiKeyVersion: String? = builder.apiKeyVersion
    /**
     * The ARN of an Amazon CloudWatch role for the current Account.
     */
    val cloudwatchRoleArn: String? = builder.cloudwatchRoleArn
    /**
     * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of "UsagePlans".
     */
    val features: List<String>? = builder.features
    /**
     * Specifies the API request limits configured for the current Account.
     */
    val throttleSettings: ThrottleSettings? = builder.throttleSettings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateAccountResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAccountResponse(")
        append("apiKeyVersion=$apiKeyVersion,")
        append("cloudwatchRoleArn=$cloudwatchRoleArn,")
        append("features=$features,")
        append("throttleSettings=$throttleSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyVersion?.hashCode() ?: 0
        result = 31 * result + (cloudwatchRoleArn?.hashCode() ?: 0)
        result = 31 * result + (features?.hashCode() ?: 0)
        result = 31 * result + (throttleSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateAccountResponse

        if (apiKeyVersion != other.apiKeyVersion) return false
        if (cloudwatchRoleArn != other.cloudwatchRoleArn) return false
        if (features != other.features) return false
        if (throttleSettings != other.throttleSettings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateAccountResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateAccountResponse
        /**
         * The version of the API keys used for the account.
         */
        fun apiKeyVersion(apiKeyVersion: String): FluentBuilder
        /**
         * The ARN of an Amazon CloudWatch role for the current Account.
         */
        fun cloudwatchRoleArn(cloudwatchRoleArn: String): FluentBuilder
        /**
         * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of "UsagePlans".
         */
        fun features(features: List<String>): FluentBuilder
        /**
         * Specifies the API request limits configured for the current Account.
         */
        fun throttleSettings(throttleSettings: ThrottleSettings): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The version of the API keys used for the account.
         */
        var apiKeyVersion: String?
        /**
         * The ARN of an Amazon CloudWatch role for the current Account.
         */
        var cloudwatchRoleArn: String?
        /**
         * A list of features supported for the account. When usage plans are enabled, the features list will include an entry of "UsagePlans".
         */
        var features: List<String>?
        /**
         * Specifies the API request limits configured for the current Account.
         */
        var throttleSettings: ThrottleSettings?

        fun build(): UpdateAccountResponse
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        fun throttleSettings(block: ThrottleSettings.DslBuilder.() -> kotlin.Unit) {
            this.throttleSettings = ThrottleSettings.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiKeyVersion: String? = null
        override var cloudwatchRoleArn: String? = null
        override var features: List<String>? = null
        override var throttleSettings: ThrottleSettings? = null

        constructor(x: UpdateAccountResponse) : this() {
            this.apiKeyVersion = x.apiKeyVersion
            this.cloudwatchRoleArn = x.cloudwatchRoleArn
            this.features = x.features
            this.throttleSettings = x.throttleSettings
        }

        override fun build(): UpdateAccountResponse = UpdateAccountResponse(this)
        override fun apiKeyVersion(apiKeyVersion: String): FluentBuilder = apply { this.apiKeyVersion = apiKeyVersion }
        override fun cloudwatchRoleArn(cloudwatchRoleArn: String): FluentBuilder = apply { this.cloudwatchRoleArn = cloudwatchRoleArn }
        override fun features(features: List<String>): FluentBuilder = apply { this.features = features }
        override fun throttleSettings(throttleSettings: ThrottleSettings): FluentBuilder = apply { this.throttleSettings = throttleSettings }
    }
}
