// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the response of the test invoke request in the HTTP method.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console">Test API using the API Gateway console
 * </div>
 */
class TestInvokeMethodResponse private constructor(builder: BuilderImpl) {
    /**
     * The body of the HTTP response.
     */
    val body: String? = builder.body
    /**
     * The headers of the HTTP response.
     */
    val headers: Map<String, String>? = builder.headers
    /**
     * The execution latency of the test invoke request.
     */
    val latency: Long = builder.latency
    /**
     * The API Gateway execution log for the test invoke request.
     */
    val log: String? = builder.log
    /**
     * The headers of the HTTP response as a map from string to list of values.
     */
    val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * The HTTP status code.
     */
    val status: Int = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TestInvokeMethodResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeMethodResponse(")
        append("body=$body,")
        append("headers=$headers,")
        append("latency=$latency,")
        append("log=$log,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (latency.hashCode())
        result = 31 * result + (log?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (status)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TestInvokeMethodResponse

        if (body != other.body) return false
        if (headers != other.headers) return false
        if (latency != other.latency) return false
        if (log != other.log) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TestInvokeMethodResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TestInvokeMethodResponse
        /**
         * The body of the HTTP response.
         */
        fun body(body: String): FluentBuilder
        /**
         * The headers of the HTTP response.
         */
        fun headers(headers: Map<String, String>): FluentBuilder
        /**
         * The execution latency of the test invoke request.
         */
        fun latency(latency: Long): FluentBuilder
        /**
         * The API Gateway execution log for the test invoke request.
         */
        fun log(log: String): FluentBuilder
        /**
         * The headers of the HTTP response as a map from string to list of values.
         */
        fun multiValueHeaders(multiValueHeaders: Map<String, List<String>>): FluentBuilder
        /**
         * The HTTP status code.
         */
        fun status(status: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The body of the HTTP response.
         */
        var body: String?
        /**
         * The headers of the HTTP response.
         */
        var headers: Map<String, String>?
        /**
         * The execution latency of the test invoke request.
         */
        var latency: Long
        /**
         * The API Gateway execution log for the test invoke request.
         */
        var log: String?
        /**
         * The headers of the HTTP response as a map from string to list of values.
         */
        var multiValueHeaders: Map<String, List<String>>?
        /**
         * The HTTP status code.
         */
        var status: Int

        fun build(): TestInvokeMethodResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var body: String? = null
        override var headers: Map<String, String>? = null
        override var latency: Long = 0L
        override var log: String? = null
        override var multiValueHeaders: Map<String, List<String>>? = null
        override var status: Int = 0

        constructor(x: TestInvokeMethodResponse) : this() {
            this.body = x.body
            this.headers = x.headers
            this.latency = x.latency
            this.log = x.log
            this.multiValueHeaders = x.multiValueHeaders
            this.status = x.status
        }

        override fun build(): TestInvokeMethodResponse = TestInvokeMethodResponse(this)
        override fun body(body: String): FluentBuilder = apply { this.body = body }
        override fun headers(headers: Map<String, String>): FluentBuilder = apply { this.headers = headers }
        override fun latency(latency: Long): FluentBuilder = apply { this.latency = latency }
        override fun log(log: String): FluentBuilder = apply { this.log = log }
        override fun multiValueHeaders(multiValueHeaders: Map<String, List<String>>): FluentBuilder = apply { this.multiValueHeaders = multiValueHeaders }
        override fun status(status: Int): FluentBuilder = apply { this.status = status }
    }
}
