// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Make a request to simulate the execution of a Method.
 */
class TestInvokeMethodRequest private constructor(builder: BuilderImpl) {
    /**
     * The simulated request body of an incoming invocation request.
     */
    val body: String? = builder.body
    /**
     * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
     */
    val clientCertificateId: String? = builder.clientCertificateId
    /**
     * A key-value map of headers to simulate an incoming invocation request.
     */
    val headers: Map<String, String>? = builder.headers
    /**
     * &#91;Required&#93; Specifies a test invoke method request's HTTP method.
     */
    val httpMethod: String? = builder.httpMethod
    /**
     * The headers as a map from string to list of values to simulate an incoming invocation request.
     */
    val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
     */
    val pathWithQueryString: String? = builder.pathWithQueryString
    /**
     * &#91;Required&#93; Specifies a test invoke method request's resource ID.
     */
    val resourceId: String? = builder.resourceId
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    val stageVariables: Map<String, String>? = builder.stageVariables

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TestInvokeMethodRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeMethodRequest(")
        append("body=$body,")
        append("clientCertificateId=$clientCertificateId,")
        append("headers=$headers,")
        append("httpMethod=$httpMethod,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("pathWithQueryString=$pathWithQueryString,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (pathWithQueryString?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TestInvokeMethodRequest

        if (body != other.body) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (headers != other.headers) return false
        if (httpMethod != other.httpMethod) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (pathWithQueryString != other.pathWithQueryString) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TestInvokeMethodRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TestInvokeMethodRequest
        /**
         * The simulated request body of an incoming invocation request.
         */
        fun body(body: String): FluentBuilder
        /**
         * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
         */
        fun clientCertificateId(clientCertificateId: String): FluentBuilder
        /**
         * A key-value map of headers to simulate an incoming invocation request.
         */
        fun headers(headers: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; Specifies a test invoke method request's HTTP method.
         */
        fun httpMethod(httpMethod: String): FluentBuilder
        /**
         * The headers as a map from string to list of values to simulate an incoming invocation request.
         */
        fun multiValueHeaders(multiValueHeaders: Map<String, List<String>>): FluentBuilder
        /**
         * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        fun pathWithQueryString(pathWithQueryString: String): FluentBuilder
        /**
         * &#91;Required&#93; Specifies a test invoke method request's resource ID.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        fun stageVariables(stageVariables: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The simulated request body of an incoming invocation request.
         */
        var body: String?
        /**
         * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
         */
        var clientCertificateId: String?
        /**
         * A key-value map of headers to simulate an incoming invocation request.
         */
        var headers: Map<String, String>?
        /**
         * &#91;Required&#93; Specifies a test invoke method request's HTTP method.
         */
        var httpMethod: String?
        /**
         * The headers as a map from string to list of values to simulate an incoming invocation request.
         */
        var multiValueHeaders: Map<String, List<String>>?
        /**
         * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        var pathWithQueryString: String?
        /**
         * &#91;Required&#93; Specifies a test invoke method request's resource ID.
         */
        var resourceId: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        var stageVariables: Map<String, String>?

        fun build(): TestInvokeMethodRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var body: String? = null
        override var clientCertificateId: String? = null
        override var headers: Map<String, String>? = null
        override var httpMethod: String? = null
        override var multiValueHeaders: Map<String, List<String>>? = null
        override var pathWithQueryString: String? = null
        override var resourceId: String? = null
        override var restApiId: String? = null
        override var stageVariables: Map<String, String>? = null

        constructor(x: TestInvokeMethodRequest) : this() {
            this.body = x.body
            this.clientCertificateId = x.clientCertificateId
            this.headers = x.headers
            this.httpMethod = x.httpMethod
            this.multiValueHeaders = x.multiValueHeaders
            this.pathWithQueryString = x.pathWithQueryString
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
            this.stageVariables = x.stageVariables
        }

        override fun build(): TestInvokeMethodRequest = TestInvokeMethodRequest(this)
        override fun body(body: String): FluentBuilder = apply { this.body = body }
        override fun clientCertificateId(clientCertificateId: String): FluentBuilder = apply { this.clientCertificateId = clientCertificateId }
        override fun headers(headers: Map<String, String>): FluentBuilder = apply { this.headers = headers }
        override fun httpMethod(httpMethod: String): FluentBuilder = apply { this.httpMethod = httpMethod }
        override fun multiValueHeaders(multiValueHeaders: Map<String, List<String>>): FluentBuilder = apply { this.multiValueHeaders = multiValueHeaders }
        override fun pathWithQueryString(pathWithQueryString: String): FluentBuilder = apply { this.pathWithQueryString = pathWithQueryString }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stageVariables(stageVariables: Map<String, String>): FluentBuilder = apply { this.stageVariables = stageVariables }
    }
}
