// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the response of the test invoke request for a custom Authorizer
 */
class TestInvokeAuthorizerResponse private constructor(builder: BuilderImpl) {
    val authorization: Map<String, List<String>>? = builder.authorization
    /**
     * The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
     */
    val claims: Map<String, String>? = builder.claims
    /**
     * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
     */
    val clientStatus: Int = builder.clientStatus
    /**
     * The execution latency of the test authorizer request.
     */
    val latency: Long = builder.latency
    /**
     * The API Gateway execution log for the test authorizer request.
     */
    val log: String? = builder.log
    /**
     * The JSON policy document returned by the Authorizer
     */
    val policy: String? = builder.policy
    /**
     * The principal identity returned by the Authorizer
     */
    val principalId: String? = builder.principalId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TestInvokeAuthorizerResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeAuthorizerResponse(")
        append("authorization=$authorization,")
        append("claims=$claims,")
        append("clientStatus=$clientStatus,")
        append("latency=$latency,")
        append("log=$log,")
        append("policy=$policy,")
        append("principalId=$principalId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorization?.hashCode() ?: 0
        result = 31 * result + (claims?.hashCode() ?: 0)
        result = 31 * result + (clientStatus)
        result = 31 * result + (latency.hashCode())
        result = 31 * result + (log?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TestInvokeAuthorizerResponse

        if (authorization != other.authorization) return false
        if (claims != other.claims) return false
        if (clientStatus != other.clientStatus) return false
        if (latency != other.latency) return false
        if (log != other.log) return false
        if (policy != other.policy) return false
        if (principalId != other.principalId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TestInvokeAuthorizerResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TestInvokeAuthorizerResponse
        fun authorization(authorization: Map<String, List<String>>): FluentBuilder
        /**
         * The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
         */
        fun claims(claims: Map<String, String>): FluentBuilder
        /**
         * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         */
        fun clientStatus(clientStatus: Int): FluentBuilder
        /**
         * The execution latency of the test authorizer request.
         */
        fun latency(latency: Long): FluentBuilder
        /**
         * The API Gateway execution log for the test authorizer request.
         */
        fun log(log: String): FluentBuilder
        /**
         * The JSON policy document returned by the Authorizer
         */
        fun policy(policy: String): FluentBuilder
        /**
         * The principal identity returned by the Authorizer
         */
        fun principalId(principalId: String): FluentBuilder
    }

    interface DslBuilder {
        var authorization: Map<String, List<String>>?
        /**
         * The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
         */
        var claims: Map<String, String>?
        /**
         * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         */
        var clientStatus: Int
        /**
         * The execution latency of the test authorizer request.
         */
        var latency: Long
        /**
         * The API Gateway execution log for the test authorizer request.
         */
        var log: String?
        /**
         * The JSON policy document returned by the Authorizer
         */
        var policy: String?
        /**
         * The principal identity returned by the Authorizer
         */
        var principalId: String?

        fun build(): TestInvokeAuthorizerResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authorization: Map<String, List<String>>? = null
        override var claims: Map<String, String>? = null
        override var clientStatus: Int = 0
        override var latency: Long = 0L
        override var log: String? = null
        override var policy: String? = null
        override var principalId: String? = null

        constructor(x: TestInvokeAuthorizerResponse) : this() {
            this.authorization = x.authorization
            this.claims = x.claims
            this.clientStatus = x.clientStatus
            this.latency = x.latency
            this.log = x.log
            this.policy = x.policy
            this.principalId = x.principalId
        }

        override fun build(): TestInvokeAuthorizerResponse = TestInvokeAuthorizerResponse(this)
        override fun authorization(authorization: Map<String, List<String>>): FluentBuilder = apply { this.authorization = authorization }
        override fun claims(claims: Map<String, String>): FluentBuilder = apply { this.claims = claims }
        override fun clientStatus(clientStatus: Int): FluentBuilder = apply { this.clientStatus = clientStatus }
        override fun latency(latency: Long): FluentBuilder = apply { this.latency = latency }
        override fun log(log: String): FluentBuilder = apply { this.log = log }
        override fun policy(policy: String): FluentBuilder = apply { this.policy = policy }
        override fun principalId(principalId: String): FluentBuilder = apply { this.principalId = principalId }
    }
}
