// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Make a request to simulate the execution of an Authorizer.
 */
class TestInvokeAuthorizerRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Optional&#93; A key-value map of additional context variables.
     */
    val additionalContext: Map<String, String>? = builder.additionalContext
    /**
     * &#91;Required&#93; Specifies a test invoke authorizer request's Authorizer ID.
     */
    val authorizerId: String? = builder.authorizerId
    /**
     * &#91;Optional&#93; The simulated request body of an incoming invocation request.
     */
    val body: String? = builder.body
    /**
     * &#91;Required&#93; A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
     */
    val headers: Map<String, String>? = builder.headers
    /**
     * &#91;Optional&#93; The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
     */
    val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * &#91;Optional&#93; The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
     */
    val pathWithQueryString: String? = builder.pathWithQueryString
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    val stageVariables: Map<String, String>? = builder.stageVariables

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TestInvokeAuthorizerRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeAuthorizerRequest(")
        append("additionalContext=$additionalContext,")
        append("authorizerId=$authorizerId,")
        append("body=$body,")
        append("headers=$headers,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("pathWithQueryString=$pathWithQueryString,")
        append("restApiId=$restApiId,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalContext?.hashCode() ?: 0
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (pathWithQueryString?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TestInvokeAuthorizerRequest

        if (additionalContext != other.additionalContext) return false
        if (authorizerId != other.authorizerId) return false
        if (body != other.body) return false
        if (headers != other.headers) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (pathWithQueryString != other.pathWithQueryString) return false
        if (restApiId != other.restApiId) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TestInvokeAuthorizerRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TestInvokeAuthorizerRequest
        /**
         * &#91;Optional&#93; A key-value map of additional context variables.
         */
        fun additionalContext(additionalContext: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; Specifies a test invoke authorizer request's Authorizer ID.
         */
        fun authorizerId(authorizerId: String): FluentBuilder
        /**
         * &#91;Optional&#93; The simulated request body of an incoming invocation request.
         */
        fun body(body: String): FluentBuilder
        /**
         * &#91;Required&#93; A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
         */
        fun headers(headers: Map<String, String>): FluentBuilder
        /**
         * &#91;Optional&#93; The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
         */
        fun multiValueHeaders(multiValueHeaders: Map<String, List<String>>): FluentBuilder
        /**
         * &#91;Optional&#93; The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        fun pathWithQueryString(pathWithQueryString: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        fun stageVariables(stageVariables: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Optional&#93; A key-value map of additional context variables.
         */
        var additionalContext: Map<String, String>?
        /**
         * &#91;Required&#93; Specifies a test invoke authorizer request's Authorizer ID.
         */
        var authorizerId: String?
        /**
         * &#91;Optional&#93; The simulated request body of an incoming invocation request.
         */
        var body: String?
        /**
         * &#91;Required&#93; A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
         */
        var headers: Map<String, String>?
        /**
         * &#91;Optional&#93; The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
         */
        var multiValueHeaders: Map<String, List<String>>?
        /**
         * &#91;Optional&#93; The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        var pathWithQueryString: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        var stageVariables: Map<String, String>?

        fun build(): TestInvokeAuthorizerRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalContext: Map<String, String>? = null
        override var authorizerId: String? = null
        override var body: String? = null
        override var headers: Map<String, String>? = null
        override var multiValueHeaders: Map<String, List<String>>? = null
        override var pathWithQueryString: String? = null
        override var restApiId: String? = null
        override var stageVariables: Map<String, String>? = null

        constructor(x: TestInvokeAuthorizerRequest) : this() {
            this.additionalContext = x.additionalContext
            this.authorizerId = x.authorizerId
            this.body = x.body
            this.headers = x.headers
            this.multiValueHeaders = x.multiValueHeaders
            this.pathWithQueryString = x.pathWithQueryString
            this.restApiId = x.restApiId
            this.stageVariables = x.stageVariables
        }

        override fun build(): TestInvokeAuthorizerRequest = TestInvokeAuthorizerRequest(this)
        override fun additionalContext(additionalContext: Map<String, String>): FluentBuilder = apply { this.additionalContext = additionalContext }
        override fun authorizerId(authorizerId: String): FluentBuilder = apply { this.authorizerId = authorizerId }
        override fun body(body: String): FluentBuilder = apply { this.body = body }
        override fun headers(headers: Map<String, String>): FluentBuilder = apply { this.headers = headers }
        override fun multiValueHeaders(multiValueHeaders: Map<String, List<String>>): FluentBuilder = apply { this.multiValueHeaders = multiValueHeaders }
        override fun pathWithQueryString(pathWithQueryString: String): FluentBuilder = apply { this.pathWithQueryString = pathWithQueryString }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stageVariables(stageVariables: Map<String, String>): FluentBuilder = apply { this.stageVariables = stageVariables }
    }
}
