// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a REST API.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API
 * </div>
 */
class RestApi private constructor(builder: BuilderImpl) {
    /**
     * The source of the API key for metering requests according to a usage plan. Valid values are: HEADER to read the API key from the X-API-Key header of a request. AUTHORIZER to read the API key from the UsageIdentifierKey from a custom authorizer.
     */
    val apiKeySource: ApiKeySourceType? = builder.apiKeySource
    /**
     * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
     */
    val binaryMediaTypes: List<String>? = builder.binaryMediaTypes
    /**
     * The timestamp when the API was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The API's description.
     */
    val description: String? = builder.description
    /**
     * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    val disableExecuteApiEndpoint: Boolean = builder.disableExecuteApiEndpoint
    /**
     * The endpoint configuration of this RestApi showing the endpoint types of the API.
     */
    val endpointConfiguration: EndpointConfiguration? = builder.endpointConfiguration
    /**
     * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
     */
    val id: String? = builder.id
    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
     */
    val minimumCompressionSize: Int? = builder.minimumCompressionSize
    /**
     * The API's name.
     */
    val name: String? = builder.name
    /**
     * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
     */
    val policy: String? = builder.policy
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * A version identifier for the API.
     */
    val version: String? = builder.version
    /**
     * The warning messages reported when failonwarnings is turned on during API import.
     */
    val warnings: List<String>? = builder.warnings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RestApi = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RestApi(")
        append("apiKeySource=$apiKeySource,")
        append("binaryMediaTypes=$binaryMediaTypes,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("disableExecuteApiEndpoint=$disableExecuteApiEndpoint,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("id=$id,")
        append("minimumCompressionSize=$minimumCompressionSize,")
        append("name=$name,")
        append("policy=$policy,")
        append("tags=$tags,")
        append("version=$version,")
        append("warnings=$warnings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeySource?.hashCode() ?: 0
        result = 31 * result + (binaryMediaTypes?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableExecuteApiEndpoint.hashCode())
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (minimumCompressionSize ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RestApi

        if (apiKeySource != other.apiKeySource) return false
        if (binaryMediaTypes != other.binaryMediaTypes) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (disableExecuteApiEndpoint != other.disableExecuteApiEndpoint) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (id != other.id) return false
        if (minimumCompressionSize != other.minimumCompressionSize) return false
        if (name != other.name) return false
        if (policy != other.policy) return false
        if (tags != other.tags) return false
        if (version != other.version) return false
        if (warnings != other.warnings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RestApi = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RestApi
        /**
         * The source of the API key for metering requests according to a usage plan. Valid values are: HEADER to read the API key from the X-API-Key header of a request. AUTHORIZER to read the API key from the UsageIdentifierKey from a custom authorizer.
         */
        fun apiKeySource(apiKeySource: ApiKeySourceType): FluentBuilder
        /**
         * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
         */
        fun binaryMediaTypes(binaryMediaTypes: List<String>): FluentBuilder
        /**
         * The timestamp when the API was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The API's description.
         */
        fun description(description: String): FluentBuilder
        /**
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        fun disableExecuteApiEndpoint(disableExecuteApiEndpoint: Boolean): FluentBuilder
        /**
         * The endpoint configuration of this RestApi showing the endpoint types of the API.
         */
        fun endpointConfiguration(endpointConfiguration: EndpointConfiguration): FluentBuilder
        /**
         * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         */
        fun id(id: String): FluentBuilder
        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
         */
        fun minimumCompressionSize(minimumCompressionSize: Int): FluentBuilder
        /**
         * The API's name.
         */
        fun name(name: String): FluentBuilder
        /**
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
         */
        fun policy(policy: String): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * A version identifier for the API.
         */
        fun version(version: String): FluentBuilder
        /**
         * The warning messages reported when failonwarnings is turned on during API import.
         */
        fun warnings(warnings: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The source of the API key for metering requests according to a usage plan. Valid values are: HEADER to read the API key from the X-API-Key header of a request. AUTHORIZER to read the API key from the UsageIdentifierKey from a custom authorizer.
         */
        var apiKeySource: ApiKeySourceType?
        /**
         * The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads.
         */
        var binaryMediaTypes: List<String>?
        /**
         * The timestamp when the API was created.
         */
        var createdDate: Instant?
        /**
         * The API's description.
         */
        var description: String?
        /**
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        var disableExecuteApiEndpoint: Boolean
        /**
         * The endpoint configuration of this RestApi showing the endpoint types of the API.
         */
        var endpointConfiguration: EndpointConfiguration?
        /**
         * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         */
        var id: String?
        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.
         */
        var minimumCompressionSize: Int?
        /**
         * The API's name.
         */
        var name: String?
        /**
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration.
         */
        var policy: String?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?
        /**
         * A version identifier for the API.
         */
        var version: String?
        /**
         * The warning messages reported when failonwarnings is turned on during API import.
         */
        var warnings: List<String>?

        fun build(): RestApi
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        fun endpointConfiguration(block: EndpointConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.endpointConfiguration = EndpointConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiKeySource: ApiKeySourceType? = null
        override var binaryMediaTypes: List<String>? = null
        override var createdDate: Instant? = null
        override var description: String? = null
        override var disableExecuteApiEndpoint: Boolean = false
        override var endpointConfiguration: EndpointConfiguration? = null
        override var id: String? = null
        override var minimumCompressionSize: Int? = null
        override var name: String? = null
        override var policy: String? = null
        override var tags: Map<String, String>? = null
        override var version: String? = null
        override var warnings: List<String>? = null

        constructor(x: RestApi) : this() {
            this.apiKeySource = x.apiKeySource
            this.binaryMediaTypes = x.binaryMediaTypes
            this.createdDate = x.createdDate
            this.description = x.description
            this.disableExecuteApiEndpoint = x.disableExecuteApiEndpoint
            this.endpointConfiguration = x.endpointConfiguration
            this.id = x.id
            this.minimumCompressionSize = x.minimumCompressionSize
            this.name = x.name
            this.policy = x.policy
            this.tags = x.tags
            this.version = x.version
            this.warnings = x.warnings
        }

        override fun build(): RestApi = RestApi(this)
        override fun apiKeySource(apiKeySource: ApiKeySourceType): FluentBuilder = apply { this.apiKeySource = apiKeySource }
        override fun binaryMediaTypes(binaryMediaTypes: List<String>): FluentBuilder = apply { this.binaryMediaTypes = binaryMediaTypes }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun disableExecuteApiEndpoint(disableExecuteApiEndpoint: Boolean): FluentBuilder = apply { this.disableExecuteApiEndpoint = disableExecuteApiEndpoint }
        override fun endpointConfiguration(endpointConfiguration: EndpointConfiguration): FluentBuilder = apply { this.endpointConfiguration = endpointConfiguration }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun minimumCompressionSize(minimumCompressionSize: Int): FluentBuilder = apply { this.minimumCompressionSize = minimumCompressionSize }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun policy(policy: String): FluentBuilder = apply { this.policy = policy }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun version(version: String): FluentBuilder = apply { this.version = version }
        override fun warnings(warnings: List<String>): FluentBuilder = apply { this.warnings = warnings }
    }
}
