// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Quotas configured for a usage plan.
 */
class QuotaSettings private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of requests that can be made in a given time period.
     */
    val limit: Int = builder.limit
    /**
     * The day that a time period starts. For example, with a time period of WEEK, an offset of 0 starts on Sunday, and an offset of 1 starts on Monday.
     */
    val offset: Int = builder.offset
    /**
     * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     */
    val period: QuotaPeriodType? = builder.period

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): QuotaSettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("QuotaSettings(")
        append("limit=$limit,")
        append("offset=$offset,")
        append("period=$period)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit
        result = 31 * result + (offset)
        result = 31 * result + (period?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as QuotaSettings

        if (limit != other.limit) return false
        if (offset != other.offset) return false
        if (period != other.period) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): QuotaSettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): QuotaSettings
        /**
         * The maximum number of requests that can be made in a given time period.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The day that a time period starts. For example, with a time period of WEEK, an offset of 0 starts on Sunday, and an offset of 1 starts on Monday.
         */
        fun offset(offset: Int): FluentBuilder
        /**
         * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
         */
        fun period(period: QuotaPeriodType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of requests that can be made in a given time period.
         */
        var limit: Int
        /**
         * The day that a time period starts. For example, with a time period of WEEK, an offset of 0 starts on Sunday, and an offset of 1 starts on Monday.
         */
        var offset: Int
        /**
         * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
         */
        var period: QuotaPeriodType?

        fun build(): QuotaSettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var limit: Int = 0
        override var offset: Int = 0
        override var period: QuotaPeriodType? = null

        constructor(x: QuotaSettings) : this() {
            this.limit = x.limit
            this.offset = x.offset
            this.period = x.period
        }

        override fun build(): QuotaSettings = QuotaSettings(this)
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun offset(offset: Int): FluentBuilder = apply { this.offset = offset }
        override fun period(period: QuotaPeriodType): FluentBuilder = apply { this.period = period }
    }
}
