// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A PUT request to update an existing API, with external API definitions specified as the request body.
 */
class PutRestApiRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
     */
    val body: ByteArray? = builder.body
    /**
     * A query parameter to indicate whether to rollback the API update (true) or not (false)
     * when a warning is encountered. The default value is false.
     */
    val failOnWarnings: Boolean = builder.failOnWarnings
    /**
     * The mode query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
     * the update mode is "merge".
     */
    val mode: PutMode? = builder.mode
    /**
     * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set ignore=documentation as a parameters value, as in the AWS CLI command of aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'.
     */
    val parameters: Map<String, String>? = builder.parameters
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutRestApiRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutRestApiRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("mode=$mode,")
        append("parameters=$parameters,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutRestApiRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (mode != other.mode) return false
        if (parameters != other.parameters) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutRestApiRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutRestApiRequest
        /**
         * &#91;Required&#93; The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
         */
        fun body(body: ByteArray): FluentBuilder
        /**
         * A query parameter to indicate whether to rollback the API update (true) or not (false)
         * when a warning is encountered. The default value is false.
         */
        fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder
        /**
         * The mode query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
         * the update mode is "merge".
         */
        fun mode(mode: PutMode): FluentBuilder
        /**
         * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set ignore=documentation as a parameters value, as in the AWS CLI command of aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'.
         */
        fun parameters(parameters: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
         */
        var body: ByteArray?
        /**
         * A query parameter to indicate whether to rollback the API update (true) or not (false)
         * when a warning is encountered. The default value is false.
         */
        var failOnWarnings: Boolean
        /**
         * The mode query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default,
         * the update mode is "merge".
         */
        var mode: PutMode?
        /**
         * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set ignore=documentation as a parameters value, as in the AWS CLI command of aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'.
         */
        var parameters: Map<String, String>?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?

        fun build(): PutRestApiRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var body: ByteArray? = null
        override var failOnWarnings: Boolean = false
        override var mode: PutMode? = null
        override var parameters: Map<String, String>? = null
        override var restApiId: String? = null

        constructor(x: PutRestApiRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.mode = x.mode
            this.parameters = x.parameters
            this.restApiId = x.restApiId
        }

        override fun build(): PutRestApiRequest = PutRestApiRequest(this)
        override fun body(body: ByteArray): FluentBuilder = apply { this.body = body }
        override fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder = apply { this.failOnWarnings = failOnWarnings }
        override fun mode(mode: PutMode): FluentBuilder = apply { this.mode = mode }
        override fun parameters(parameters: Map<String, String>): FluentBuilder = apply { this.parameters = parameters }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
    }
}
