// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to add a MethodResponse to an existing Method resource.
 */
class PutMethodResponseRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; The HTTP verb of the Method resource.
     */
    val httpMethod: String? = builder.httpMethod
    /**
     * &#91;Required&#93; The Resource identifier for the Method resource.
     */
    val resourceId: String? = builder.resourceId
    /**
     * Specifies the Model resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value.
     */
    val responseModels: Map<String, String>? = builder.responseModels
    /**
     * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in integration.response.header.{name}, a static value enclosed within a pair of single quotes (e.g., 'application/json'), or a JSON expression from the back-end response payload in the form of integration.response.body.{JSON-expression}, where JSON-expression is a valid JSON expression without the $ prefix.)
     */
    val responseParameters: Map<String, Boolean>? = builder.responseParameters
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * &#91;Required&#93; The method response's status code.
     */
    val statusCode: String? = builder.statusCode

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutMethodResponseRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutMethodResponseRequest(")
        append("httpMethod=$httpMethod,")
        append("resourceId=$resourceId,")
        append("responseModels=$responseModels,")
        append("responseParameters=$responseParameters,")
        append("restApiId=$restApiId,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpMethod?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (responseModels?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutMethodResponseRequest

        if (httpMethod != other.httpMethod) return false
        if (resourceId != other.resourceId) return false
        if (responseModels != other.responseModels) return false
        if (responseParameters != other.responseParameters) return false
        if (restApiId != other.restApiId) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutMethodResponseRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutMethodResponseRequest
        /**
         * &#91;Required&#93; The HTTP verb of the Method resource.
         */
        fun httpMethod(httpMethod: String): FluentBuilder
        /**
         * &#91;Required&#93; The Resource identifier for the Method resource.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * Specifies the Model resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value.
         */
        fun responseModels(responseModels: Map<String, String>): FluentBuilder
        /**
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in integration.response.header.{name}, a static value enclosed within a pair of single quotes (e.g., 'application/json'), or a JSON expression from the back-end response payload in the form of integration.response.body.{JSON-expression}, where JSON-expression is a valid JSON expression without the $ prefix.)
         */
        fun responseParameters(responseParameters: Map<String, Boolean>): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * &#91;Required&#93; The method response's status code.
         */
        fun statusCode(statusCode: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; The HTTP verb of the Method resource.
         */
        var httpMethod: String?
        /**
         * &#91;Required&#93; The Resource identifier for the Method resource.
         */
        var resourceId: String?
        /**
         * Specifies the Model resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value.
         */
        var responseModels: Map<String, String>?
        /**
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in integration.response.header.{name}, a static value enclosed within a pair of single quotes (e.g., 'application/json'), or a JSON expression from the back-end response payload in the form of integration.response.body.{JSON-expression}, where JSON-expression is a valid JSON expression without the $ prefix.)
         */
        var responseParameters: Map<String, Boolean>?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * &#91;Required&#93; The method response's status code.
         */
        var statusCode: String?

        fun build(): PutMethodResponseRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var httpMethod: String? = null
        override var resourceId: String? = null
        override var responseModels: Map<String, String>? = null
        override var responseParameters: Map<String, Boolean>? = null
        override var restApiId: String? = null
        override var statusCode: String? = null

        constructor(x: PutMethodResponseRequest) : this() {
            this.httpMethod = x.httpMethod
            this.resourceId = x.resourceId
            this.responseModels = x.responseModels
            this.responseParameters = x.responseParameters
            this.restApiId = x.restApiId
            this.statusCode = x.statusCode
        }

        override fun build(): PutMethodResponseRequest = PutMethodResponseRequest(this)
        override fun httpMethod(httpMethod: String): FluentBuilder = apply { this.httpMethod = httpMethod }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun responseModels(responseModels: Map<String, String>): FluentBuilder = apply { this.responseModels = responseModels }
        override fun responseParameters(responseParameters: Map<String, Boolean>): FluentBuilder = apply { this.responseParameters = responseParameters }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun statusCode(statusCode: String): FluentBuilder = apply { this.statusCode = statusCode }
    }
}
