// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to add a method to an existing Resource resource.
 */
class PutMethodRequest private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the method required a valid ApiKey.
     */
    val apiKeyRequired: Boolean = builder.apiKeyRequired
    /**
     * A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    val authorizationScopes: List<String>? = builder.authorizationScopes
    /**
     * &#91;Required&#93; The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
     */
    val authorizationType: String? = builder.authorizationType
    /**
     * Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
     */
    val authorizerId: String? = builder.authorizerId
    /**
     * &#91;Required&#93; Specifies the method request's HTTP method type.
     */
    val httpMethod: String? = builder.httpMethod
    /**
     * A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example.
     */
    val operationName: String? = builder.operationName
    /**
     * Specifies the Model resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value.
     */
    val requestModels: Map<String, String>? = builder.requestModels
    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false).  The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates.
     */
    val requestParameters: Map<String, Boolean>? = builder.requestParameters
    /**
     * The identifier of a RequestValidator for validating the method request.
     */
    val requestValidatorId: String? = builder.requestValidatorId
    /**
     * &#91;Required&#93; The Resource identifier for the new Method resource.
     */
    val resourceId: String? = builder.resourceId
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutMethodRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutMethodRequest(")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationScopes=$authorizationScopes,")
        append("authorizationType=$authorizationType,")
        append("authorizerId=$authorizerId,")
        append("httpMethod=$httpMethod,")
        append("operationName=$operationName,")
        append("requestModels=$requestModels,")
        append("requestParameters=$requestParameters,")
        append("requestValidatorId=$requestValidatorId,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyRequired.hashCode()
        result = 31 * result + (authorizationScopes?.hashCode() ?: 0)
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (operationName?.hashCode() ?: 0)
        result = 31 * result + (requestModels?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestValidatorId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutMethodRequest

        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationScopes != other.authorizationScopes) return false
        if (authorizationType != other.authorizationType) return false
        if (authorizerId != other.authorizerId) return false
        if (httpMethod != other.httpMethod) return false
        if (operationName != other.operationName) return false
        if (requestModels != other.requestModels) return false
        if (requestParameters != other.requestParameters) return false
        if (requestValidatorId != other.requestValidatorId) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutMethodRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutMethodRequest
        /**
         * Specifies whether the method required a valid ApiKey.
         */
        fun apiKeyRequired(apiKeyRequired: Boolean): FluentBuilder
        /**
         * A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        fun authorizationScopes(authorizationScopes: List<String>): FluentBuilder
        /**
         * &#91;Required&#93; The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
         */
        fun authorizationType(authorizationType: String): FluentBuilder
        /**
         * Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
         */
        fun authorizerId(authorizerId: String): FluentBuilder
        /**
         * &#91;Required&#93; Specifies the method request's HTTP method type.
         */
        fun httpMethod(httpMethod: String): FluentBuilder
        /**
         * A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example.
         */
        fun operationName(operationName: String): FluentBuilder
        /**
         * Specifies the Model resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value.
         */
        fun requestModels(requestModels: Map<String, String>): FluentBuilder
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false).  The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates.
         */
        fun requestParameters(requestParameters: Map<String, Boolean>): FluentBuilder
        /**
         * The identifier of a RequestValidator for validating the method request.
         */
        fun requestValidatorId(requestValidatorId: String): FluentBuilder
        /**
         * &#91;Required&#93; The Resource identifier for the new Method resource.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the method required a valid ApiKey.
         */
        var apiKeyRequired: Boolean
        /**
         * A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        var authorizationScopes: List<String>?
        /**
         * &#91;Required&#93; The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
         */
        var authorizationType: String?
        /**
         * Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
         */
        var authorizerId: String?
        /**
         * &#91;Required&#93; Specifies the method request's HTTP method type.
         */
        var httpMethod: String?
        /**
         * A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example.
         */
        var operationName: String?
        /**
         * Specifies the Model resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value.
         */
        var requestModels: Map<String, String>?
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false).  The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates.
         */
        var requestParameters: Map<String, Boolean>?
        /**
         * The identifier of a RequestValidator for validating the method request.
         */
        var requestValidatorId: String?
        /**
         * &#91;Required&#93; The Resource identifier for the new Method resource.
         */
        var resourceId: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?

        fun build(): PutMethodRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiKeyRequired: Boolean = false
        override var authorizationScopes: List<String>? = null
        override var authorizationType: String? = null
        override var authorizerId: String? = null
        override var httpMethod: String? = null
        override var operationName: String? = null
        override var requestModels: Map<String, String>? = null
        override var requestParameters: Map<String, Boolean>? = null
        override var requestValidatorId: String? = null
        override var resourceId: String? = null
        override var restApiId: String? = null

        constructor(x: PutMethodRequest) : this() {
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationScopes = x.authorizationScopes
            this.authorizationType = x.authorizationType
            this.authorizerId = x.authorizerId
            this.httpMethod = x.httpMethod
            this.operationName = x.operationName
            this.requestModels = x.requestModels
            this.requestParameters = x.requestParameters
            this.requestValidatorId = x.requestValidatorId
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
        }

        override fun build(): PutMethodRequest = PutMethodRequest(this)
        override fun apiKeyRequired(apiKeyRequired: Boolean): FluentBuilder = apply { this.apiKeyRequired = apiKeyRequired }
        override fun authorizationScopes(authorizationScopes: List<String>): FluentBuilder = apply { this.authorizationScopes = authorizationScopes }
        override fun authorizationType(authorizationType: String): FluentBuilder = apply { this.authorizationType = authorizationType }
        override fun authorizerId(authorizerId: String): FluentBuilder = apply { this.authorizerId = authorizerId }
        override fun httpMethod(httpMethod: String): FluentBuilder = apply { this.httpMethod = httpMethod }
        override fun operationName(operationName: String): FluentBuilder = apply { this.operationName = operationName }
        override fun requestModels(requestModels: Map<String, String>): FluentBuilder = apply { this.requestModels = requestModels }
        override fun requestParameters(requestParameters: Map<String, Boolean>): FluentBuilder = apply { this.requestParameters = requestParameters }
        override fun requestValidatorId(requestValidatorId: String): FluentBuilder = apply { this.requestValidatorId = requestValidatorId }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
    }
}
