// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an integration response. The status code must map to an existing MethodResponse, and parameters and templates can be used to transform the back-end response.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API
 * </div>
 */
class PutIntegrationResponseResponse private constructor(builder: BuilderImpl) {
    /**
     * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
     */
    val contentHandling: ContentHandlingStrategy? = builder.contentHandling
    /**
     * A key-value map specifying response parameters that are passed to the method response from the back end.
     * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
     */
    val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
     */
    val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the .+ regex to match error response. However, make sure that the error response does not contain any newline (\n) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
     */
    val selectionPattern: String? = builder.selectionPattern
    /**
     * Specifies the status code that is used to map the integration response to an existing MethodResponse.
     */
    val statusCode: String? = builder.statusCode

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutIntegrationResponseResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationResponseResponse(")
        append("contentHandling=$contentHandling,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("selectionPattern=$selectionPattern,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentHandling?.hashCode() ?: 0
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (selectionPattern?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutIntegrationResponseResponse

        if (contentHandling != other.contentHandling) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (selectionPattern != other.selectionPattern) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutIntegrationResponseResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutIntegrationResponseResponse
        /**
         * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
         */
        fun contentHandling(contentHandling: ContentHandlingStrategy): FluentBuilder
        /**
         * A key-value map specifying response parameters that are passed to the method response from the back end.
         * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
         */
        fun responseParameters(responseParameters: Map<String, String>): FluentBuilder
        /**
         * Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         */
        fun responseTemplates(responseTemplates: Map<String, String>): FluentBuilder
        /**
         * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the .+ regex to match error response. However, make sure that the error response does not contain any newline (\n) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
         */
        fun selectionPattern(selectionPattern: String): FluentBuilder
        /**
         * Specifies the status code that is used to map the integration response to an existing MethodResponse.
         */
        fun statusCode(statusCode: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
         */
        var contentHandling: ContentHandlingStrategy?
        /**
         * A key-value map specifying response parameters that are passed to the method response from the back end.
         * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
         */
        var responseParameters: Map<String, String>?
        /**
         * Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         */
        var responseTemplates: Map<String, String>?
        /**
         * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the .+ regex to match error response. However, make sure that the error response does not contain any newline (\n) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
         */
        var selectionPattern: String?
        /**
         * Specifies the status code that is used to map the integration response to an existing MethodResponse.
         */
        var statusCode: String?

        fun build(): PutIntegrationResponseResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contentHandling: ContentHandlingStrategy? = null
        override var responseParameters: Map<String, String>? = null
        override var responseTemplates: Map<String, String>? = null
        override var selectionPattern: String? = null
        override var statusCode: String? = null

        constructor(x: PutIntegrationResponseResponse) : this() {
            this.contentHandling = x.contentHandling
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.selectionPattern = x.selectionPattern
            this.statusCode = x.statusCode
        }

        override fun build(): PutIntegrationResponseResponse = PutIntegrationResponseResponse(this)
        override fun contentHandling(contentHandling: ContentHandlingStrategy): FluentBuilder = apply { this.contentHandling = contentHandling }
        override fun responseParameters(responseParameters: Map<String, String>): FluentBuilder = apply { this.responseParameters = responseParameters }
        override fun responseTemplates(responseTemplates: Map<String, String>): FluentBuilder = apply { this.responseTemplates = responseTemplates }
        override fun selectionPattern(selectionPattern: String): FluentBuilder = apply { this.selectionPattern = selectionPattern }
        override fun statusCode(statusCode: String): FluentBuilder = apply { this.statusCode = statusCode }
    }
}
