// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.
 * <div class="remarks">In the API Gateway console, the built-in Lambda integration is an AWS integration.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API
 * </div>
 */
class PutIntegrationResponse private constructor(builder: BuilderImpl) {
    /**
     * A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters.
     */
    val cacheKeyParameters: List<String>? = builder.cacheKeyParameters
    /**
     * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources.
     */
    val cacheNamespace: String? = builder.cacheNamespace
    /**
     * The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id">id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise.
     */
    val connectionId: String? = builder.connectionId
    /**
     * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET.
     */
    val connectionType: ConnectionType? = builder.connectionType
    /**
     * Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
     * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.
     * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through.
     */
    val contentHandling: ContentHandlingStrategy? = builder.contentHandling
    /**
     * Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::\*:user/\*. To use resource-based permissions on supported AWS services, specify null.
     */
    val credentials: String? = builder.credentials
    /**
     * Specifies the integration's HTTP method type.
     */
    val httpMethod: String? = builder.httpMethod
    /**
     * Specifies the integration's responses.
     * <div class="remarks">
     * <h4>Example: Get integration responses of a method</h4>
     * <h5>Request</h5>
     * <pre>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
     * Content-Type: application/json
     * Host: apigateway.us-east-1.amazonaws.com
     * X-Amz-Date: 20160607T191449Z
     * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
     * </pre>
     * <h5>Response</h5>
     * The successful response returns 200 OK status and a payload as follows:
     * <pre>{
     * "_links": {
     * "curies": {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
     * "name": "integrationresponse",
     * "templated": true
     * },
     * "self": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
     * "title": "200"
     * },
     * "integrationresponse:delete": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
     * },
     * "integrationresponse:update": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
     * }
     * },
     * "responseParameters": {
     * "method.response.header.Content-Type": "'application/xml'"
     * },
     * "responseTemplates": {
     * "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
     * },
     * "statusCode": "200"
     * }</pre>
     * </div>
     * <div class="seeAlso">
     * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API
     * </div>
     */
    val integrationResponses: Map<String, IntegrationResponse>? = builder.integrationResponses
    /**
     * <div>
     * Specifies how the method request body of an unmapped content type will be passed through the integration request
     * to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
     * or the content type does not match any of the mapped content types, as specified in requestTemplates.
     * The valid value is one of the following:
     * WHEN_NO_MATCH: passes the method request body through the integration request to the back end without transformation
     * when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
     * WHEN_NO_TEMPLATES: passes the method request body through the integration request to the back end without transformation
     * when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
     * of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response.
     * NEVER: rejects the method request with an HTTP 415 Unsupported Media Type response when either the method
     * request content type does not match any content type associated with the mapping templates defined in the integration request or
     * no mapping template is defined in the integration request.
     * </div>
     */
    val passthroughBehavior: String? = builder.passthroughBehavior
    /**
     * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name.
     */
    val requestParameters: Map<String, String>? = builder.requestParameters
    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
     */
    val requestTemplates: Map<String, String>? = builder.requestTemplates
    /**
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
     */
    val timeoutInMillis: Int = builder.timeoutInMillis
    /**
     * Specifies the TLS configuration for an integration.
     */
    val tlsConfig: TlsConfig? = builder.tlsConfig
    /**
     * Specifies an API method integration type. The valid value is one of the following:
     * AWS: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.
     * AWS_PROXY: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.
     * HTTP: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
     * HTTP_PROXY: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.
     * MOCK: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.
     * For the HTTP and HTTP proxy integrations, each integration can specify a protocol (http/https), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a connectionType of VPC_LINK is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
     */
    val type: IntegrationType? = builder.type
    /**
     * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
     * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
     * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing  service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or  arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
     */
    val uri: String? = builder.uri

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutIntegrationResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationResponse(")
        append("cacheKeyParameters=$cacheKeyParameters,")
        append("cacheNamespace=$cacheNamespace,")
        append("connectionId=$connectionId,")
        append("connectionType=$connectionType,")
        append("contentHandling=$contentHandling,")
        append("credentials=$credentials,")
        append("httpMethod=$httpMethod,")
        append("integrationResponses=$integrationResponses,")
        append("passthroughBehavior=$passthroughBehavior,")
        append("requestParameters=$requestParameters,")
        append("requestTemplates=$requestTemplates,")
        append("timeoutInMillis=$timeoutInMillis,")
        append("tlsConfig=$tlsConfig,")
        append("type=$type,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheKeyParameters?.hashCode() ?: 0
        result = 31 * result + (cacheNamespace?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (contentHandling?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (integrationResponses?.hashCode() ?: 0)
        result = 31 * result + (passthroughBehavior?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestTemplates?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMillis)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutIntegrationResponse

        if (cacheKeyParameters != other.cacheKeyParameters) return false
        if (cacheNamespace != other.cacheNamespace) return false
        if (connectionId != other.connectionId) return false
        if (connectionType != other.connectionType) return false
        if (contentHandling != other.contentHandling) return false
        if (credentials != other.credentials) return false
        if (httpMethod != other.httpMethod) return false
        if (integrationResponses != other.integrationResponses) return false
        if (passthroughBehavior != other.passthroughBehavior) return false
        if (requestParameters != other.requestParameters) return false
        if (requestTemplates != other.requestTemplates) return false
        if (timeoutInMillis != other.timeoutInMillis) return false
        if (tlsConfig != other.tlsConfig) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutIntegrationResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutIntegrationResponse
        /**
         * A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters.
         */
        fun cacheKeyParameters(cacheKeyParameters: List<String>): FluentBuilder
        /**
         * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources.
         */
        fun cacheNamespace(cacheNamespace: String): FluentBuilder
        /**
         * The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id">id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise.
         */
        fun connectionId(connectionId: String): FluentBuilder
        /**
         * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET.
         */
        fun connectionType(connectionType: ConnectionType): FluentBuilder
        /**
         * Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through.
         */
        fun contentHandling(contentHandling: ContentHandlingStrategy): FluentBuilder
        /**
         * Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::\*:user/\*. To use resource-based permissions on supported AWS services, specify null.
         */
        fun credentials(credentials: String): FluentBuilder
        /**
         * Specifies the integration's HTTP method type.
         */
        fun httpMethod(httpMethod: String): FluentBuilder
        /**
         * Specifies the integration's responses.
         * <div class="remarks">
         * <h4>Example: Get integration responses of a method</h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * X-Amz-Date: 20160607T191449Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
         * </pre>
         * <h5>Response</h5>
         * The successful response returns 200 OK status and a payload as follows:
         * <pre>{
         * "_links": {
         * "curies": {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
         * "name": "integrationresponse",
         * "templated": true
         * },
         * "self": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
         * "title": "200"
         * },
         * "integrationresponse:delete": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
         * },
         * "integrationresponse:update": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
         * }
         * },
         * "responseParameters": {
         * "method.response.header.Content-Type": "'application/xml'"
         * },
         * "responseTemplates": {
         * "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
         * },
         * "statusCode": "200"
         * }</pre>
         * </div>
         * <div class="seeAlso">
         * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API
         * </div>
         */
        fun integrationResponses(integrationResponses: Map<String, IntegrationResponse>): FluentBuilder
        /**
         * <div>
         * Specifies how the method request body of an unmapped content type will be passed through the integration request
         * to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
         * or the content type does not match any of the mapped content types, as specified in requestTemplates.
         * The valid value is one of the following:
         * WHEN_NO_MATCH: passes the method request body through the integration request to the back end without transformation
         * when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
         * WHEN_NO_TEMPLATES: passes the method request body through the integration request to the back end without transformation
         * when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
         * of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response.
         * NEVER: rejects the method request with an HTTP 415 Unsupported Media Type response when either the method
         * request content type does not match any content type associated with the mapping templates defined in the integration request or
         * no mapping template is defined in the integration request.
         * </div>
         */
        fun passthroughBehavior(passthroughBehavior: String): FluentBuilder
        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name.
         */
        fun requestParameters(requestParameters: Map<String, String>): FluentBuilder
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
         */
        fun requestTemplates(requestTemplates: Map<String, String>): FluentBuilder
        /**
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         */
        fun timeoutInMillis(timeoutInMillis: Int): FluentBuilder
        /**
         * Specifies the TLS configuration for an integration.
         */
        fun tlsConfig(tlsConfig: TlsConfig): FluentBuilder
        /**
         * Specifies an API method integration type. The valid value is one of the following:
         * AWS: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.
         * AWS_PROXY: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.
         * HTTP: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
         * HTTP_PROXY: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.
         * MOCK: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.
         * For the HTTP and HTTP proxy integrations, each integration can specify a protocol (http/https), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a connectionType of VPC_LINK is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
         */
        fun type(type: IntegrationType): FluentBuilder
        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
         * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
         * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing  service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or  arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
         */
        fun uri(uri: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters.
         */
        var cacheKeyParameters: List<String>?
        /**
         * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources.
         */
        var cacheNamespace: String?
        /**
         * The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id">id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise.
         */
        var connectionId: String?
        /**
         * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET.
         */
        var connectionType: ConnectionType?
        /**
         * Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through.
         */
        var contentHandling: ContentHandlingStrategy?
        /**
         * Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::\*:user/\*. To use resource-based permissions on supported AWS services, specify null.
         */
        var credentials: String?
        /**
         * Specifies the integration's HTTP method type.
         */
        var httpMethod: String?
        /**
         * Specifies the integration's responses.
         * <div class="remarks">
         * <h4>Example: Get integration responses of a method</h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * X-Amz-Date: 20160607T191449Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
         * </pre>
         * <h5>Response</h5>
         * The successful response returns 200 OK status and a payload as follows:
         * <pre>{
         * "_links": {
         * "curies": {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
         * "name": "integrationresponse",
         * "templated": true
         * },
         * "self": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
         * "title": "200"
         * },
         * "integrationresponse:delete": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
         * },
         * "integrationresponse:update": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
         * }
         * },
         * "responseParameters": {
         * "method.response.header.Content-Type": "'application/xml'"
         * },
         * "responseTemplates": {
         * "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
         * },
         * "statusCode": "200"
         * }</pre>
         * </div>
         * <div class="seeAlso">
         * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API
         * </div>
         */
        var integrationResponses: Map<String, IntegrationResponse>?
        /**
         * <div>
         * Specifies how the method request body of an unmapped content type will be passed through the integration request
         * to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration
         * or the content type does not match any of the mapped content types, as specified in requestTemplates.
         * The valid value is one of the following:
         * WHEN_NO_MATCH: passes the method request body through the integration request to the back end without transformation
         * when the method request content type does not match any content type associated with the mapping templates defined in the integration request.
         * WHEN_NO_TEMPLATES: passes the method request body through the integration request to the back end without transformation
         * when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request
         * of an unmapped content-type will be rejected with an HTTP 415 Unsupported Media Type response.
         * NEVER: rejects the method request with an HTTP 415 Unsupported Media Type response when either the method
         * request content type does not match any content type associated with the mapping templates defined in the integration request or
         * no mapping template is defined in the integration request.
         * </div>
         */
        var passthroughBehavior: String?
        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name.
         */
        var requestParameters: Map<String, String>?
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
         */
        var requestTemplates: Map<String, String>?
        /**
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         */
        var timeoutInMillis: Int
        /**
         * Specifies the TLS configuration for an integration.
         */
        var tlsConfig: TlsConfig?
        /**
         * Specifies an API method integration type. The valid value is one of the following:
         * AWS: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.
         * AWS_PROXY: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.
         * HTTP: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.
         * HTTP_PROXY: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.
         * MOCK: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.
         * For the HTTP and HTTP proxy integrations, each integration can specify a protocol (http/https), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a connectionType of VPC_LINK is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
         */
        var type: IntegrationType?
        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
         * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
         * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing  service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or  arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
         */
        var uri: String?

        fun build(): PutIntegrationResponse
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.TlsConfig] inside the given [block]
         */
        fun tlsConfig(block: TlsConfig.DslBuilder.() -> kotlin.Unit) {
            this.tlsConfig = TlsConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheKeyParameters: List<String>? = null
        override var cacheNamespace: String? = null
        override var connectionId: String? = null
        override var connectionType: ConnectionType? = null
        override var contentHandling: ContentHandlingStrategy? = null
        override var credentials: String? = null
        override var httpMethod: String? = null
        override var integrationResponses: Map<String, IntegrationResponse>? = null
        override var passthroughBehavior: String? = null
        override var requestParameters: Map<String, String>? = null
        override var requestTemplates: Map<String, String>? = null
        override var timeoutInMillis: Int = 0
        override var tlsConfig: TlsConfig? = null
        override var type: IntegrationType? = null
        override var uri: String? = null

        constructor(x: PutIntegrationResponse) : this() {
            this.cacheKeyParameters = x.cacheKeyParameters
            this.cacheNamespace = x.cacheNamespace
            this.connectionId = x.connectionId
            this.connectionType = x.connectionType
            this.contentHandling = x.contentHandling
            this.credentials = x.credentials
            this.httpMethod = x.httpMethod
            this.integrationResponses = x.integrationResponses
            this.passthroughBehavior = x.passthroughBehavior
            this.requestParameters = x.requestParameters
            this.requestTemplates = x.requestTemplates
            this.timeoutInMillis = x.timeoutInMillis
            this.tlsConfig = x.tlsConfig
            this.type = x.type
            this.uri = x.uri
        }

        override fun build(): PutIntegrationResponse = PutIntegrationResponse(this)
        override fun cacheKeyParameters(cacheKeyParameters: List<String>): FluentBuilder = apply { this.cacheKeyParameters = cacheKeyParameters }
        override fun cacheNamespace(cacheNamespace: String): FluentBuilder = apply { this.cacheNamespace = cacheNamespace }
        override fun connectionId(connectionId: String): FluentBuilder = apply { this.connectionId = connectionId }
        override fun connectionType(connectionType: ConnectionType): FluentBuilder = apply { this.connectionType = connectionType }
        override fun contentHandling(contentHandling: ContentHandlingStrategy): FluentBuilder = apply { this.contentHandling = contentHandling }
        override fun credentials(credentials: String): FluentBuilder = apply { this.credentials = credentials }
        override fun httpMethod(httpMethod: String): FluentBuilder = apply { this.httpMethod = httpMethod }
        override fun integrationResponses(integrationResponses: Map<String, IntegrationResponse>): FluentBuilder = apply { this.integrationResponses = integrationResponses }
        override fun passthroughBehavior(passthroughBehavior: String): FluentBuilder = apply { this.passthroughBehavior = passthroughBehavior }
        override fun requestParameters(requestParameters: Map<String, String>): FluentBuilder = apply { this.requestParameters = requestParameters }
        override fun requestTemplates(requestTemplates: Map<String, String>): FluentBuilder = apply { this.requestTemplates = requestTemplates }
        override fun timeoutInMillis(timeoutInMillis: Int): FluentBuilder = apply { this.timeoutInMillis = timeoutInMillis }
        override fun tlsConfig(tlsConfig: TlsConfig): FluentBuilder = apply { this.tlsConfig = tlsConfig }
        override fun type(type: IntegrationType): FluentBuilder = apply { this.type = type }
        override fun uri(uri: String): FluentBuilder = apply { this.uri = uri }
    }
}
