// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Sets up a method's integration.
 */
class PutIntegrationRequest private constructor(builder: BuilderImpl) {
    /**
     * A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters.
     */
    val cacheKeyParameters: List<String>? = builder.cacheKeyParameters
    /**
     * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources.
     */
    val cacheNamespace: String? = builder.cacheNamespace
    /**
     * The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id">id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise.
     */
    val connectionId: String? = builder.connectionId
    /**
     * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET.
     */
    val connectionType: ConnectionType? = builder.connectionType
    /**
     * Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
     * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.
     * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through.
     */
    val contentHandling: ContentHandlingStrategy? = builder.contentHandling
    /**
     * Specifies whether credentials are required for a put integration.
     */
    val credentials: String? = builder.credentials
    /**
     * &#91;Required&#93; Specifies a put integration request's HTTP method.
     */
    val httpMethod: String? = builder.httpMethod
    /**
     * Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.
     */
    val integrationHttpMethod: String? = builder.integrationHttpMethod
    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values:  WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
     * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration back end without transformation.
     * NEVER rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
     * WHEN_NO_TEMPLATES allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.
     */
    val passthroughBehavior: String? = builder.passthroughBehavior
    /**
     * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name.
     */
    val requestParameters: Map<String, String>? = builder.requestParameters
    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
     */
    val requestTemplates: Map<String, String>? = builder.requestTemplates
    /**
     * &#91;Required&#93; Specifies a put integration request's resource ID.
     */
    val resourceId: String? = builder.resourceId
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
     */
    val timeoutInMillis: Int? = builder.timeoutInMillis
    val tlsConfig: TlsConfig? = builder.tlsConfig
    /**
     * &#91;Required&#93; Specifies a put integration input's type.
     */
    val type: IntegrationType? = builder.type
    /**
     * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
     * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
     * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing  service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or  arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
     */
    val uri: String? = builder.uri

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutIntegrationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationRequest(")
        append("cacheKeyParameters=$cacheKeyParameters,")
        append("cacheNamespace=$cacheNamespace,")
        append("connectionId=$connectionId,")
        append("connectionType=$connectionType,")
        append("contentHandling=$contentHandling,")
        append("credentials=$credentials,")
        append("httpMethod=$httpMethod,")
        append("integrationHttpMethod=$integrationHttpMethod,")
        append("passthroughBehavior=$passthroughBehavior,")
        append("requestParameters=$requestParameters,")
        append("requestTemplates=$requestTemplates,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId,")
        append("timeoutInMillis=$timeoutInMillis,")
        append("tlsConfig=$tlsConfig,")
        append("type=$type,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheKeyParameters?.hashCode() ?: 0
        result = 31 * result + (cacheNamespace?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (contentHandling?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (integrationHttpMethod?.hashCode() ?: 0)
        result = 31 * result + (passthroughBehavior?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestTemplates?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMillis ?: 0)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutIntegrationRequest

        if (cacheKeyParameters != other.cacheKeyParameters) return false
        if (cacheNamespace != other.cacheNamespace) return false
        if (connectionId != other.connectionId) return false
        if (connectionType != other.connectionType) return false
        if (contentHandling != other.contentHandling) return false
        if (credentials != other.credentials) return false
        if (httpMethod != other.httpMethod) return false
        if (integrationHttpMethod != other.integrationHttpMethod) return false
        if (passthroughBehavior != other.passthroughBehavior) return false
        if (requestParameters != other.requestParameters) return false
        if (requestTemplates != other.requestTemplates) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false
        if (timeoutInMillis != other.timeoutInMillis) return false
        if (tlsConfig != other.tlsConfig) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutIntegrationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutIntegrationRequest
        /**
         * A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters.
         */
        fun cacheKeyParameters(cacheKeyParameters: List<String>): FluentBuilder
        /**
         * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources.
         */
        fun cacheNamespace(cacheNamespace: String): FluentBuilder
        /**
         * The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id">id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise.
         */
        fun connectionId(connectionId: String): FluentBuilder
        /**
         * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET.
         */
        fun connectionType(connectionType: ConnectionType): FluentBuilder
        /**
         * Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through.
         */
        fun contentHandling(contentHandling: ContentHandlingStrategy): FluentBuilder
        /**
         * Specifies whether credentials are required for a put integration.
         */
        fun credentials(credentials: String): FluentBuilder
        /**
         * &#91;Required&#93; Specifies a put integration request's HTTP method.
         */
        fun httpMethod(httpMethod: String): FluentBuilder
        /**
         * Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.
         */
        fun integrationHttpMethod(integrationHttpMethod: String): FluentBuilder
        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values:  WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration back end without transformation.
         * NEVER rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
         * WHEN_NO_TEMPLATES allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.
         */
        fun passthroughBehavior(passthroughBehavior: String): FluentBuilder
        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name.
         */
        fun requestParameters(requestParameters: Map<String, String>): FluentBuilder
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
         */
        fun requestTemplates(requestTemplates: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; Specifies a put integration request's resource ID.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         */
        fun timeoutInMillis(timeoutInMillis: Int): FluentBuilder
        fun tlsConfig(tlsConfig: TlsConfig): FluentBuilder
        /**
         * &#91;Required&#93; Specifies a put integration input's type.
         */
        fun type(type: IntegrationType): FluentBuilder
        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
         * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
         * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing  service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or  arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
         */
        fun uri(uri: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters.
         */
        var cacheKeyParameters: List<String>?
        /**
         * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources.
         */
        var cacheNamespace: String?
        /**
         * The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id">id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise.
         */
        var connectionId: String?
        /**
         * The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET.
         */
        var connectionType: ConnectionType?
        /**
         * Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through.
         */
        var contentHandling: ContentHandlingStrategy?
        /**
         * Specifies whether credentials are required for a put integration.
         */
        var credentials: String?
        /**
         * &#91;Required&#93; Specifies a put integration request's HTTP method.
         */
        var httpMethod: String?
        /**
         * Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.
         */
        var integrationHttpMethod: String?
        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values:  WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration back end without transformation.
         * NEVER rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
         * WHEN_NO_TEMPLATES allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.
         */
        var passthroughBehavior: String?
        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name.
         */
        var requestParameters: Map<String, String>?
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
         */
        var requestTemplates: Map<String, String>?
        /**
         * &#91;Required&#93; Specifies a put integration request's resource ID.
         */
        var resourceId: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         */
        var timeoutInMillis: Int?
        var tlsConfig: TlsConfig?
        /**
         * &#91;Required&#93; Specifies a put integration input's type.
         */
        var type: IntegrationType?
        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint.
         * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.
         * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing  service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or  arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
         */
        var uri: String?

        fun build(): PutIntegrationRequest
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.TlsConfig] inside the given [block]
         */
        fun tlsConfig(block: TlsConfig.DslBuilder.() -> kotlin.Unit) {
            this.tlsConfig = TlsConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheKeyParameters: List<String>? = null
        override var cacheNamespace: String? = null
        override var connectionId: String? = null
        override var connectionType: ConnectionType? = null
        override var contentHandling: ContentHandlingStrategy? = null
        override var credentials: String? = null
        override var httpMethod: String? = null
        override var integrationHttpMethod: String? = null
        override var passthroughBehavior: String? = null
        override var requestParameters: Map<String, String>? = null
        override var requestTemplates: Map<String, String>? = null
        override var resourceId: String? = null
        override var restApiId: String? = null
        override var timeoutInMillis: Int? = null
        override var tlsConfig: TlsConfig? = null
        override var type: IntegrationType? = null
        override var uri: String? = null

        constructor(x: PutIntegrationRequest) : this() {
            this.cacheKeyParameters = x.cacheKeyParameters
            this.cacheNamespace = x.cacheNamespace
            this.connectionId = x.connectionId
            this.connectionType = x.connectionType
            this.contentHandling = x.contentHandling
            this.credentials = x.credentials
            this.httpMethod = x.httpMethod
            this.integrationHttpMethod = x.integrationHttpMethod
            this.passthroughBehavior = x.passthroughBehavior
            this.requestParameters = x.requestParameters
            this.requestTemplates = x.requestTemplates
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
            this.timeoutInMillis = x.timeoutInMillis
            this.tlsConfig = x.tlsConfig
            this.type = x.type
            this.uri = x.uri
        }

        override fun build(): PutIntegrationRequest = PutIntegrationRequest(this)
        override fun cacheKeyParameters(cacheKeyParameters: List<String>): FluentBuilder = apply { this.cacheKeyParameters = cacheKeyParameters }
        override fun cacheNamespace(cacheNamespace: String): FluentBuilder = apply { this.cacheNamespace = cacheNamespace }
        override fun connectionId(connectionId: String): FluentBuilder = apply { this.connectionId = connectionId }
        override fun connectionType(connectionType: ConnectionType): FluentBuilder = apply { this.connectionType = connectionType }
        override fun contentHandling(contentHandling: ContentHandlingStrategy): FluentBuilder = apply { this.contentHandling = contentHandling }
        override fun credentials(credentials: String): FluentBuilder = apply { this.credentials = credentials }
        override fun httpMethod(httpMethod: String): FluentBuilder = apply { this.httpMethod = httpMethod }
        override fun integrationHttpMethod(integrationHttpMethod: String): FluentBuilder = apply { this.integrationHttpMethod = integrationHttpMethod }
        override fun passthroughBehavior(passthroughBehavior: String): FluentBuilder = apply { this.passthroughBehavior = passthroughBehavior }
        override fun requestParameters(requestParameters: Map<String, String>): FluentBuilder = apply { this.requestParameters = requestParameters }
        override fun requestTemplates(requestTemplates: Map<String, String>): FluentBuilder = apply { this.requestTemplates = requestTemplates }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun timeoutInMillis(timeoutInMillis: Int): FluentBuilder = apply { this.timeoutInMillis = timeoutInMillis }
        override fun tlsConfig(tlsConfig: TlsConfig): FluentBuilder = apply { this.tlsConfig = tlsConfig }
        override fun type(type: IntegrationType): FluentBuilder = apply { this.type = type }
        override fun uri(uri: String): FluentBuilder = apply { this.uri = uri }
    }
}
