// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
 */
class PutGatewayResponseRequest private constructor(builder: BuilderImpl) {
    /**
     * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value  pairs.
     */
    val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
     */
    val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * &#91;Required&#93; The response type of the associated GatewayResponse.
     */
    val responseType: GatewayResponseType? = builder.responseType
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * The HTTP status code of the GatewayResponse.
     */
    val statusCode: String? = builder.statusCode

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutGatewayResponseRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutGatewayResponseRequest(")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("responseType=$responseType,")
        append("restApiId=$restApiId,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = responseParameters?.hashCode() ?: 0
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (responseType?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutGatewayResponseRequest

        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (responseType != other.responseType) return false
        if (restApiId != other.restApiId) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutGatewayResponseRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutGatewayResponseRequest
        /**
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value  pairs.
         */
        fun responseParameters(responseParameters: Map<String, String>): FluentBuilder
        /**
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        fun responseTemplates(responseTemplates: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; The response type of the associated GatewayResponse.
         */
        fun responseType(responseType: GatewayResponseType): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * The HTTP status code of the GatewayResponse.
         */
        fun statusCode(statusCode: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value  pairs.
         */
        var responseParameters: Map<String, String>?
        /**
         * Response templates of the GatewayResponse as a string-to-string map of key-value pairs.
         */
        var responseTemplates: Map<String, String>?
        /**
         * &#91;Required&#93; The response type of the associated GatewayResponse.
         */
        var responseType: GatewayResponseType?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * The HTTP status code of the GatewayResponse.
         */
        var statusCode: String?

        fun build(): PutGatewayResponseRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var responseParameters: Map<String, String>? = null
        override var responseTemplates: Map<String, String>? = null
        override var responseType: GatewayResponseType? = null
        override var restApiId: String? = null
        override var statusCode: String? = null

        constructor(x: PutGatewayResponseRequest) : this() {
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.responseType = x.responseType
            this.restApiId = x.restApiId
            this.statusCode = x.statusCode
        }

        override fun build(): PutGatewayResponseRequest = PutGatewayResponseRequest(this)
        override fun responseParameters(responseParameters: Map<String, String>): FluentBuilder = apply { this.responseParameters = responseParameters }
        override fun responseTemplates(responseTemplates: Map<String, String>): FluentBuilder = apply { this.responseTemplates = responseTemplates }
        override fun responseType(responseType: GatewayResponseType): FluentBuilder = apply { this.responseType = responseType }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun statusCode(statusCode: String): FluentBuilder = apply { this.statusCode = statusCode }
    }
}
