// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A single patch operation to apply to the specified resource. Please refer to
 * http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how each operation is used.
 */
class PatchOperation private constructor(builder: BuilderImpl) {
    /**
     * The copy update operation's source as identified by a JSON-Pointer value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a Stage resource with "op":"copy", "from":"/canarySettings/deploymentId" and "path":"/deploymentId".
     */
    val from: String? = builder.from
    /**
     * An update operation to be performed with this PATCH request. The valid value can be add, remove,  replace or copy. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.
     */
    val op: Op? = builder.op
    /**
     * The op operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer value that references a location within the targeted resource. For example, if the target resource has an updateable property of {"name":"value"}, the path for this property is /name. If the name property value is a JSON object (e.g., {"name": {"child/name": "child-value"}}), the path for the child/name property will be /name/child~1name. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each op operation can have only one path associated with it.
     */
    val path: String? = builder.path
    /**
     * The new target value of the update operation. It is applicable for the add or replace operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PatchOperation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PatchOperation(")
        append("from=$from,")
        append("op=$op,")
        append("path=$path,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = from?.hashCode() ?: 0
        result = 31 * result + (op?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PatchOperation

        if (from != other.from) return false
        if (op != other.op) return false
        if (path != other.path) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PatchOperation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PatchOperation
        /**
         * The copy update operation's source as identified by a JSON-Pointer value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a Stage resource with "op":"copy", "from":"/canarySettings/deploymentId" and "path":"/deploymentId".
         */
        fun from(from: String): FluentBuilder
        /**
         * An update operation to be performed with this PATCH request. The valid value can be add, remove,  replace or copy. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.
         */
        fun op(op: Op): FluentBuilder
        /**
         * The op operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer value that references a location within the targeted resource. For example, if the target resource has an updateable property of {"name":"value"}, the path for this property is /name. If the name property value is a JSON object (e.g., {"name": {"child/name": "child-value"}}), the path for the child/name property will be /name/child~1name. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each op operation can have only one path associated with it.
         */
        fun path(path: String): FluentBuilder
        /**
         * The new target value of the update operation. It is applicable for the add or replace operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The copy update operation's source as identified by a JSON-Pointer value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a Stage resource with "op":"copy", "from":"/canarySettings/deploymentId" and "path":"/deploymentId".
         */
        var from: String?
        /**
         * An update operation to be performed with this PATCH request. The valid value can be add, remove,  replace or copy. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.
         */
        var op: Op?
        /**
         * The op operation's target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer value that references a location within the targeted resource. For example, if the target resource has an updateable property of {"name":"value"}, the path for this property is /name. If the name property value is a JSON object (e.g., {"name": {"child/name": "child-value"}}), the path for the child/name property will be /name/child~1name. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each op operation can have only one path associated with it.
         */
        var path: String?
        /**
         * The new target value of the update operation. It is applicable for the add or replace operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters.
         */
        var value: String?

        fun build(): PatchOperation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var from: String? = null
        override var op: Op? = null
        override var path: String? = null
        override var value: String? = null

        constructor(x: PatchOperation) : this() {
            this.from = x.from
            this.op = x.op
            this.path = x.path
            this.value = x.value
        }

        override fun build(): PatchOperation = PatchOperation(this)
        override fun from(from: String): FluentBuilder = apply { this.from = from }
        override fun op(op: Op): FluentBuilder = apply { this.op = op }
        override fun path(path: String): FluentBuilder = apply { this.path = path }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
