// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.
 */
class MutualTlsAuthenticationInput private constructor(builder: BuilderImpl) {
    /**
     * An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
     * for example,
     * s3://bucket-name/key-name.
     * The truststore can contain certificates from public or private certificate authorities.
     * To update the truststore, upload a new version to S3, and then update your custom domain
     * name to use the new version. To update the truststore, you must have permissions to
     * access the S3 object.
     */
    val truststoreUri: String? = builder.truststoreUri
    /**
     * The version of the S3 object that contains your truststore. To
     * specify a version, you must have versioning enabled for the S3 bucket.
     */
    val truststoreVersion: String? = builder.truststoreVersion

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MutualTlsAuthenticationInput = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MutualTlsAuthenticationInput(")
        append("truststoreUri=$truststoreUri,")
        append("truststoreVersion=$truststoreVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = truststoreUri?.hashCode() ?: 0
        result = 31 * result + (truststoreVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MutualTlsAuthenticationInput

        if (truststoreUri != other.truststoreUri) return false
        if (truststoreVersion != other.truststoreVersion) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MutualTlsAuthenticationInput = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MutualTlsAuthenticationInput
        /**
         * An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
         * for example,
         * s3://bucket-name/key-name.
         * The truststore can contain certificates from public or private certificate authorities.
         * To update the truststore, upload a new version to S3, and then update your custom domain
         * name to use the new version. To update the truststore, you must have permissions to
         * access the S3 object.
         */
        fun truststoreUri(truststoreUri: String): FluentBuilder
        /**
         * The version of the S3 object that contains your truststore. To
         * specify a version, you must have versioning enabled for the S3 bucket.
         */
        fun truststoreVersion(truststoreVersion: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
         * for example,
         * s3://bucket-name/key-name.
         * The truststore can contain certificates from public or private certificate authorities.
         * To update the truststore, upload a new version to S3, and then update your custom domain
         * name to use the new version. To update the truststore, you must have permissions to
         * access the S3 object.
         */
        var truststoreUri: String?
        /**
         * The version of the S3 object that contains your truststore. To
         * specify a version, you must have versioning enabled for the S3 bucket.
         */
        var truststoreVersion: String?

        fun build(): MutualTlsAuthenticationInput
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var truststoreUri: String? = null
        override var truststoreVersion: String? = null

        constructor(x: MutualTlsAuthenticationInput) : this() {
            this.truststoreUri = x.truststoreUri
            this.truststoreVersion = x.truststoreVersion
        }

        override fun build(): MutualTlsAuthenticationInput = MutualTlsAuthenticationInput(this)
        override fun truststoreUri(truststoreUri: String): FluentBuilder = apply { this.truststoreUri = truststoreUri }
        override fun truststoreVersion(truststoreVersion: String): FluentBuilder = apply { this.truststoreVersion = truststoreVersion }
    }
}
