// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name.
 */
class MutualTlsAuthentication private constructor(builder: BuilderImpl) {
    /**
     * An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
     * for example s3://bucket-name/key-name.
     * The truststore can contain certificates from public or private certificate authorities.
     * To update the truststore, upload a new version to S3, and then update your custom domain
     * name to use the new version. To update the truststore, you must have permissions to
     * access the S3 object.
     */
    val truststoreUri: String? = builder.truststoreUri
    /**
     * The version of the S3 object that contains your truststore. To
     * specify a version, you must have versioning enabled for the S3 bucket.
     */
    val truststoreVersion: String? = builder.truststoreVersion
    /**
     * A list of warnings that API Gateway returns while processing your truststore. Invalid
     * certificates produce warnings. Mutual TLS is still enabled, but some clients might not
     * be able to access your API. To resolve warnings, upload a new truststore to S3, and then
     * update you domain name to use the new version.
     */
    val truststoreWarnings: List<String>? = builder.truststoreWarnings

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MutualTlsAuthentication = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MutualTlsAuthentication(")
        append("truststoreUri=$truststoreUri,")
        append("truststoreVersion=$truststoreVersion,")
        append("truststoreWarnings=$truststoreWarnings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = truststoreUri?.hashCode() ?: 0
        result = 31 * result + (truststoreVersion?.hashCode() ?: 0)
        result = 31 * result + (truststoreWarnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MutualTlsAuthentication

        if (truststoreUri != other.truststoreUri) return false
        if (truststoreVersion != other.truststoreVersion) return false
        if (truststoreWarnings != other.truststoreWarnings) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MutualTlsAuthentication = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MutualTlsAuthentication
        /**
         * An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
         * for example s3://bucket-name/key-name.
         * The truststore can contain certificates from public or private certificate authorities.
         * To update the truststore, upload a new version to S3, and then update your custom domain
         * name to use the new version. To update the truststore, you must have permissions to
         * access the S3 object.
         */
        fun truststoreUri(truststoreUri: String): FluentBuilder
        /**
         * The version of the S3 object that contains your truststore. To
         * specify a version, you must have versioning enabled for the S3 bucket.
         */
        fun truststoreVersion(truststoreVersion: String): FluentBuilder
        /**
         * A list of warnings that API Gateway returns while processing your truststore. Invalid
         * certificates produce warnings. Mutual TLS is still enabled, but some clients might not
         * be able to access your API. To resolve warnings, upload a new truststore to S3, and then
         * update you domain name to use the new version.
         */
        fun truststoreWarnings(truststoreWarnings: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
         * for example s3://bucket-name/key-name.
         * The truststore can contain certificates from public or private certificate authorities.
         * To update the truststore, upload a new version to S3, and then update your custom domain
         * name to use the new version. To update the truststore, you must have permissions to
         * access the S3 object.
         */
        var truststoreUri: String?
        /**
         * The version of the S3 object that contains your truststore. To
         * specify a version, you must have versioning enabled for the S3 bucket.
         */
        var truststoreVersion: String?
        /**
         * A list of warnings that API Gateway returns while processing your truststore. Invalid
         * certificates produce warnings. Mutual TLS is still enabled, but some clients might not
         * be able to access your API. To resolve warnings, upload a new truststore to S3, and then
         * update you domain name to use the new version.
         */
        var truststoreWarnings: List<String>?

        fun build(): MutualTlsAuthentication
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var truststoreUri: String? = null
        override var truststoreVersion: String? = null
        override var truststoreWarnings: List<String>? = null

        constructor(x: MutualTlsAuthentication) : this() {
            this.truststoreUri = x.truststoreUri
            this.truststoreVersion = x.truststoreVersion
            this.truststoreWarnings = x.truststoreWarnings
        }

        override fun build(): MutualTlsAuthentication = MutualTlsAuthentication(this)
        override fun truststoreUri(truststoreUri: String): FluentBuilder = apply { this.truststoreUri = truststoreUri }
        override fun truststoreVersion(truststoreVersion: String): FluentBuilder = apply { this.truststoreVersion = truststoreVersion }
        override fun truststoreWarnings(truststoreWarnings: List<String>): FluentBuilder = apply { this.truststoreWarnings = truststoreWarnings }
    }
}
