// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the data structure of a method's request or response payload.
 * <div class="remarks">
 * A request model defines the data structure of the client-supplied request payload. A response model defines the data structure of the response payload returned by the back end. Although not required, models are useful for mapping payloads between the front end and back end.
 * A model is used for generating an API's SDK, validating the input request body, and creating a skeletal mapping template.
 * </div>
 * <div class="seeAlso">
 * Method, MethodResponse, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings
 * </div>
 */
class Model private constructor(builder: BuilderImpl) {
    /**
     * The content-type for the model.
     */
    val contentType: String? = builder.contentType
    /**
     * The description of the model.
     */
    val description: String? = builder.description
    /**
     * The identifier for the model resource.
     */
    val id: String? = builder.id
    /**
     * The name of the model. Must be an alphanumeric string.
     */
    val name: String? = builder.name
    /**
     * The schema for the model. For application/json models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4 model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
     */
    val schema: String? = builder.schema

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Model = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Model(")
        append("contentType=$contentType,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("schema=$schema)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Model

        if (contentType != other.contentType) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (schema != other.schema) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Model = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Model
        /**
         * The content-type for the model.
         */
        fun contentType(contentType: String): FluentBuilder
        /**
         * The description of the model.
         */
        fun description(description: String): FluentBuilder
        /**
         * The identifier for the model resource.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name of the model. Must be an alphanumeric string.
         */
        fun name(name: String): FluentBuilder
        /**
         * The schema for the model. For application/json models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4 model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
         */
        fun schema(schema: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The content-type for the model.
         */
        var contentType: String?
        /**
         * The description of the model.
         */
        var description: String?
        /**
         * The identifier for the model resource.
         */
        var id: String?
        /**
         * The name of the model. Must be an alphanumeric string.
         */
        var name: String?
        /**
         * The schema for the model. For application/json models, this should be <a target="_blank" href="https://tools.ietf.org/html/draft-zyp-json-schema-04">JSON schema draft 4 model. Do not include "\*&#47;" characters in the description of any properties because such "\*&#47;" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API's SDK generated by API Gateway to fail.
         */
        var schema: String?

        fun build(): Model
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contentType: String? = null
        override var description: String? = null
        override var id: String? = null
        override var name: String? = null
        override var schema: String? = null

        constructor(x: Model) : this() {
            this.contentType = x.contentType
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.schema = x.schema
        }

        override fun build(): Model = Model(this)
        override fun contentType(contentType: String): FluentBuilder = apply { this.contentType = contentType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun schema(schema: String): FluentBuilder = apply { this.schema = schema }
    }
}
