// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a summary of a Method resource, given a particular date and time.
 */
class MethodSnapshot private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the method requires a valid ApiKey.
     */
    val apiKeyRequired: Boolean = builder.apiKeyRequired
    /**
     * The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
     */
    val authorizationType: String? = builder.authorizationType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MethodSnapshot = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MethodSnapshot(")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationType=$authorizationType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyRequired.hashCode()
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MethodSnapshot

        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationType != other.authorizationType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MethodSnapshot = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MethodSnapshot
        /**
         * Specifies whether the method requires a valid ApiKey.
         */
        fun apiKeyRequired(apiKeyRequired: Boolean): FluentBuilder
        /**
         * The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
         */
        fun authorizationType(authorizationType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the method requires a valid ApiKey.
         */
        var apiKeyRequired: Boolean
        /**
         * The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
         */
        var authorizationType: String?

        fun build(): MethodSnapshot
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiKeyRequired: Boolean = false
        override var authorizationType: String? = null

        constructor(x: MethodSnapshot) : this() {
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationType = x.authorizationType
        }

        override fun build(): MethodSnapshot = MethodSnapshot(this)
        override fun apiKeyRequired(apiKeyRequired: Boolean): FluentBuilder = apply { this.apiKeyRequired = apiKeyRequired }
        override fun authorizationType(authorizationType: String): FluentBuilder = apply { this.authorizationType = authorizationType }
    }
}
