// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Specifies the method setting properties.
 */
class MethodSetting private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the cached responses are encrypted. The PATCH path for this setting is /{method_setting_key}/caching/dataEncrypted, and the value is a Boolean.
     */
    val cacheDataEncrypted: Boolean = builder.cacheDataEncrypted
    /**
     * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is /{method_setting_key}/caching/ttlInSeconds, and the value is an integer.
     */
    val cacheTtlInSeconds: Int = builder.cacheTtlInSeconds
    /**
     * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is /{method_setting_key}/caching/enabled, and the value is a Boolean.
     */
    val cachingEnabled: Boolean = builder.cachingEnabled
    /**
     * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/dataTrace, and the value is a Boolean.
     */
    val dataTraceEnabled: Boolean = builder.dataTraceEnabled
    /**
     * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/loglevel, and the available levels are OFF, ERROR, and INFO. Choose ERROR to write only error-level entries to CloudWatch Logs, or choose INFO to include all ERROR events as well as extra informational events.
     */
    val loggingLevel: String? = builder.loggingLevel
    /**
     * Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is /{method_setting_key}/metrics/enabled, and the value is a Boolean.
     */
    val metricsEnabled: Boolean = builder.metricsEnabled
    /**
     * Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is /{method_setting_key}/caching/requireAuthorizationForCacheControl, and the value is a Boolean.
     */
    val requireAuthorizationForCacheControl: Boolean = builder.requireAuthorizationForCacheControl
    /**
     * Specifies the throttling burst limit. The PATCH path for this setting is /{method_setting_key}/throttling/burstLimit, and the value is an integer.
     */
    val throttlingBurstLimit: Int = builder.throttlingBurstLimit
    /**
     * Specifies the throttling rate limit. The PATCH path for this setting is /{method_setting_key}/throttling/rateLimit, and the value is a double.
     */
    val throttlingRateLimit: Double = builder.throttlingRateLimit
    /**
     * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is /{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy, and the available values are FAIL_WITH_403, SUCCEED_WITH_RESPONSE_HEADER, SUCCEED_WITHOUT_RESPONSE_HEADER.
     */
    val unauthorizedCacheControlHeaderStrategy: UnauthorizedCacheControlHeaderStrategy? = builder.unauthorizedCacheControlHeaderStrategy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MethodSetting = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MethodSetting(")
        append("cacheDataEncrypted=$cacheDataEncrypted,")
        append("cacheTtlInSeconds=$cacheTtlInSeconds,")
        append("cachingEnabled=$cachingEnabled,")
        append("dataTraceEnabled=$dataTraceEnabled,")
        append("loggingLevel=$loggingLevel,")
        append("metricsEnabled=$metricsEnabled,")
        append("requireAuthorizationForCacheControl=$requireAuthorizationForCacheControl,")
        append("throttlingBurstLimit=$throttlingBurstLimit,")
        append("throttlingRateLimit=$throttlingRateLimit,")
        append("unauthorizedCacheControlHeaderStrategy=$unauthorizedCacheControlHeaderStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheDataEncrypted.hashCode()
        result = 31 * result + (cacheTtlInSeconds)
        result = 31 * result + (cachingEnabled.hashCode())
        result = 31 * result + (dataTraceEnabled.hashCode())
        result = 31 * result + (loggingLevel?.hashCode() ?: 0)
        result = 31 * result + (metricsEnabled.hashCode())
        result = 31 * result + (requireAuthorizationForCacheControl.hashCode())
        result = 31 * result + (throttlingBurstLimit)
        result = 31 * result + (throttlingRateLimit.hashCode())
        result = 31 * result + (unauthorizedCacheControlHeaderStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MethodSetting

        if (cacheDataEncrypted != other.cacheDataEncrypted) return false
        if (cacheTtlInSeconds != other.cacheTtlInSeconds) return false
        if (cachingEnabled != other.cachingEnabled) return false
        if (dataTraceEnabled != other.dataTraceEnabled) return false
        if (loggingLevel != other.loggingLevel) return false
        if (metricsEnabled != other.metricsEnabled) return false
        if (requireAuthorizationForCacheControl != other.requireAuthorizationForCacheControl) return false
        if (throttlingBurstLimit != other.throttlingBurstLimit) return false
        if (throttlingRateLimit != other.throttlingRateLimit) return false
        if (unauthorizedCacheControlHeaderStrategy != other.unauthorizedCacheControlHeaderStrategy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MethodSetting = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MethodSetting
        /**
         * Specifies whether the cached responses are encrypted. The PATCH path for this setting is /{method_setting_key}/caching/dataEncrypted, and the value is a Boolean.
         */
        fun cacheDataEncrypted(cacheDataEncrypted: Boolean): FluentBuilder
        /**
         * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is /{method_setting_key}/caching/ttlInSeconds, and the value is an integer.
         */
        fun cacheTtlInSeconds(cacheTtlInSeconds: Int): FluentBuilder
        /**
         * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is /{method_setting_key}/caching/enabled, and the value is a Boolean.
         */
        fun cachingEnabled(cachingEnabled: Boolean): FluentBuilder
        /**
         * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/dataTrace, and the value is a Boolean.
         */
        fun dataTraceEnabled(dataTraceEnabled: Boolean): FluentBuilder
        /**
         * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/loglevel, and the available levels are OFF, ERROR, and INFO. Choose ERROR to write only error-level entries to CloudWatch Logs, or choose INFO to include all ERROR events as well as extra informational events.
         */
        fun loggingLevel(loggingLevel: String): FluentBuilder
        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is /{method_setting_key}/metrics/enabled, and the value is a Boolean.
         */
        fun metricsEnabled(metricsEnabled: Boolean): FluentBuilder
        /**
         * Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is /{method_setting_key}/caching/requireAuthorizationForCacheControl, and the value is a Boolean.
         */
        fun requireAuthorizationForCacheControl(requireAuthorizationForCacheControl: Boolean): FluentBuilder
        /**
         * Specifies the throttling burst limit. The PATCH path for this setting is /{method_setting_key}/throttling/burstLimit, and the value is an integer.
         */
        fun throttlingBurstLimit(throttlingBurstLimit: Int): FluentBuilder
        /**
         * Specifies the throttling rate limit. The PATCH path for this setting is /{method_setting_key}/throttling/rateLimit, and the value is a double.
         */
        fun throttlingRateLimit(throttlingRateLimit: Double): FluentBuilder
        /**
         * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is /{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy, and the available values are FAIL_WITH_403, SUCCEED_WITH_RESPONSE_HEADER, SUCCEED_WITHOUT_RESPONSE_HEADER.
         */
        fun unauthorizedCacheControlHeaderStrategy(unauthorizedCacheControlHeaderStrategy: UnauthorizedCacheControlHeaderStrategy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the cached responses are encrypted. The PATCH path for this setting is /{method_setting_key}/caching/dataEncrypted, and the value is a Boolean.
         */
        var cacheDataEncrypted: Boolean
        /**
         * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is /{method_setting_key}/caching/ttlInSeconds, and the value is an integer.
         */
        var cacheTtlInSeconds: Int
        /**
         * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is /{method_setting_key}/caching/enabled, and the value is a Boolean.
         */
        var cachingEnabled: Boolean
        /**
         * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/dataTrace, and the value is a Boolean.
         */
        var dataTraceEnabled: Boolean
        /**
         * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/loglevel, and the available levels are OFF, ERROR, and INFO. Choose ERROR to write only error-level entries to CloudWatch Logs, or choose INFO to include all ERROR events as well as extra informational events.
         */
        var loggingLevel: String?
        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is /{method_setting_key}/metrics/enabled, and the value is a Boolean.
         */
        var metricsEnabled: Boolean
        /**
         * Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is /{method_setting_key}/caching/requireAuthorizationForCacheControl, and the value is a Boolean.
         */
        var requireAuthorizationForCacheControl: Boolean
        /**
         * Specifies the throttling burst limit. The PATCH path for this setting is /{method_setting_key}/throttling/burstLimit, and the value is an integer.
         */
        var throttlingBurstLimit: Int
        /**
         * Specifies the throttling rate limit. The PATCH path for this setting is /{method_setting_key}/throttling/rateLimit, and the value is a double.
         */
        var throttlingRateLimit: Double
        /**
         * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is /{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy, and the available values are FAIL_WITH_403, SUCCEED_WITH_RESPONSE_HEADER, SUCCEED_WITHOUT_RESPONSE_HEADER.
         */
        var unauthorizedCacheControlHeaderStrategy: UnauthorizedCacheControlHeaderStrategy?

        fun build(): MethodSetting
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheDataEncrypted: Boolean = false
        override var cacheTtlInSeconds: Int = 0
        override var cachingEnabled: Boolean = false
        override var dataTraceEnabled: Boolean = false
        override var loggingLevel: String? = null
        override var metricsEnabled: Boolean = false
        override var requireAuthorizationForCacheControl: Boolean = false
        override var throttlingBurstLimit: Int = 0
        override var throttlingRateLimit: Double = 0.0
        override var unauthorizedCacheControlHeaderStrategy: UnauthorizedCacheControlHeaderStrategy? = null

        constructor(x: MethodSetting) : this() {
            this.cacheDataEncrypted = x.cacheDataEncrypted
            this.cacheTtlInSeconds = x.cacheTtlInSeconds
            this.cachingEnabled = x.cachingEnabled
            this.dataTraceEnabled = x.dataTraceEnabled
            this.loggingLevel = x.loggingLevel
            this.metricsEnabled = x.metricsEnabled
            this.requireAuthorizationForCacheControl = x.requireAuthorizationForCacheControl
            this.throttlingBurstLimit = x.throttlingBurstLimit
            this.throttlingRateLimit = x.throttlingRateLimit
            this.unauthorizedCacheControlHeaderStrategy = x.unauthorizedCacheControlHeaderStrategy
        }

        override fun build(): MethodSetting = MethodSetting(this)
        override fun cacheDataEncrypted(cacheDataEncrypted: Boolean): FluentBuilder = apply { this.cacheDataEncrypted = cacheDataEncrypted }
        override fun cacheTtlInSeconds(cacheTtlInSeconds: Int): FluentBuilder = apply { this.cacheTtlInSeconds = cacheTtlInSeconds }
        override fun cachingEnabled(cachingEnabled: Boolean): FluentBuilder = apply { this.cachingEnabled = cachingEnabled }
        override fun dataTraceEnabled(dataTraceEnabled: Boolean): FluentBuilder = apply { this.dataTraceEnabled = dataTraceEnabled }
        override fun loggingLevel(loggingLevel: String): FluentBuilder = apply { this.loggingLevel = loggingLevel }
        override fun metricsEnabled(metricsEnabled: Boolean): FluentBuilder = apply { this.metricsEnabled = metricsEnabled }
        override fun requireAuthorizationForCacheControl(requireAuthorizationForCacheControl: Boolean): FluentBuilder = apply { this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl }
        override fun throttlingBurstLimit(throttlingBurstLimit: Int): FluentBuilder = apply { this.throttlingBurstLimit = throttlingBurstLimit }
        override fun throttlingRateLimit(throttlingRateLimit: Double): FluentBuilder = apply { this.throttlingRateLimit = throttlingRateLimit }
        override fun unauthorizedCacheControlHeaderStrategy(unauthorizedCacheControlHeaderStrategy: UnauthorizedCacheControlHeaderStrategy): FluentBuilder = apply { this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy }
    }
}
