// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A POST request to import an API to API Gateway using an input of an API definition file.
 */
class ImportRestApiRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
     */
    val body: ByteArray? = builder.body
    /**
     * A query parameter to indicate whether to rollback the API creation (true) or not (false)
     * when a warning is encountered. The default value is false.
     */
    val failOnWarnings: Boolean = builder.failOnWarnings
    /**
     * A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.
     * To exclude DocumentationParts from the import, set parameters as ignore=documentation.
     * To configure the endpoint type, set parameters as endpointConfigurationTypes=EDGE, endpointConfigurationTypes=REGIONAL, or endpointConfigurationTypes=PRIVATE. The default endpoint type is EDGE.
     * To handle imported basepath, set parameters as basepath=ignore, basepath=prepend or basepath=split.
     * For example, the AWS CLI command to exclude documentation from the imported API is:
     * <pre>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</pre>
     * The AWS CLI command to set the regional endpoint on the imported API is:
     * <pre>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</pre>
     */
    val parameters: Map<String, String>? = builder.parameters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportRestApiRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportRestApiRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("parameters=$parameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportRestApiRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (parameters != other.parameters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportRestApiRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportRestApiRequest
        /**
         * &#91;Required&#93; The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
         */
        fun body(body: ByteArray): FluentBuilder
        /**
         * A query parameter to indicate whether to rollback the API creation (true) or not (false)
         * when a warning is encountered. The default value is false.
         */
        fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder
        /**
         * A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.
         * To exclude DocumentationParts from the import, set parameters as ignore=documentation.
         * To configure the endpoint type, set parameters as endpointConfigurationTypes=EDGE, endpointConfigurationTypes=REGIONAL, or endpointConfigurationTypes=PRIVATE. The default endpoint type is EDGE.
         * To handle imported basepath, set parameters as basepath=ignore, basepath=prepend or basepath=split.
         * For example, the AWS CLI command to exclude documentation from the imported API is:
         * <pre>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</pre>
         * The AWS CLI command to set the regional endpoint on the imported API is:
         * <pre>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</pre>
         */
        fun parameters(parameters: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
         */
        var body: ByteArray?
        /**
         * A query parameter to indicate whether to rollback the API creation (true) or not (false)
         * when a warning is encountered. The default value is false.
         */
        var failOnWarnings: Boolean
        /**
         * A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.
         * To exclude DocumentationParts from the import, set parameters as ignore=documentation.
         * To configure the endpoint type, set parameters as endpointConfigurationTypes=EDGE, endpointConfigurationTypes=REGIONAL, or endpointConfigurationTypes=PRIVATE. The default endpoint type is EDGE.
         * To handle imported basepath, set parameters as basepath=ignore, basepath=prepend or basepath=split.
         * For example, the AWS CLI command to exclude documentation from the imported API is:
         * <pre>aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'</pre>
         * The AWS CLI command to set the regional endpoint on the imported API is:
         * <pre>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'</pre>
         */
        var parameters: Map<String, String>?

        fun build(): ImportRestApiRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var body: ByteArray? = null
        override var failOnWarnings: Boolean = false
        override var parameters: Map<String, String>? = null

        constructor(x: ImportRestApiRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.parameters = x.parameters
        }

        override fun build(): ImportRestApiRequest = ImportRestApiRequest(this)
        override fun body(body: ByteArray): FluentBuilder = apply { this.body = body }
        override fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder = apply { this.failOnWarnings = failOnWarnings }
        override fun parameters(parameters: Map<String, String>): FluentBuilder = apply { this.parameters = parameters }
    }
}
