// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Import documentation parts from an external (e.g., OpenAPI) definition file.
 */
class ImportDocumentationPartsRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.
     */
    val body: ByteArray? = builder.body
    /**
     * A query parameter to specify whether to rollback the documentation importation (true) or not (false) when a warning is encountered. The default value is false.
     */
    val failOnWarnings: Boolean = builder.failOnWarnings
    /**
     * A query parameter to indicate whether to overwrite (OVERWRITE) any existing DocumentationParts definition or to merge (MERGE) the new definition into the existing one. The default value is MERGE.
     */
    val mode: PutMode? = builder.mode
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportDocumentationPartsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportDocumentationPartsRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("mode=$mode,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportDocumentationPartsRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (mode != other.mode) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportDocumentationPartsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportDocumentationPartsRequest
        /**
         * &#91;Required&#93; Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.
         */
        fun body(body: ByteArray): FluentBuilder
        /**
         * A query parameter to specify whether to rollback the documentation importation (true) or not (false) when a warning is encountered. The default value is false.
         */
        fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder
        /**
         * A query parameter to indicate whether to overwrite (OVERWRITE) any existing DocumentationParts definition or to merge (MERGE) the new definition into the existing one. The default value is MERGE.
         */
        fun mode(mode: PutMode): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.
         */
        var body: ByteArray?
        /**
         * A query parameter to specify whether to rollback the documentation importation (true) or not (false) when a warning is encountered. The default value is false.
         */
        var failOnWarnings: Boolean
        /**
         * A query parameter to indicate whether to overwrite (OVERWRITE) any existing DocumentationParts definition or to merge (MERGE) the new definition into the existing one. The default value is MERGE.
         */
        var mode: PutMode?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?

        fun build(): ImportDocumentationPartsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var body: ByteArray? = null
        override var failOnWarnings: Boolean = false
        override var mode: PutMode? = null
        override var restApiId: String? = null

        constructor(x: ImportDocumentationPartsRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.mode = x.mode
            this.restApiId = x.restApiId
        }

        override fun build(): ImportDocumentationPartsRequest = ImportDocumentationPartsRequest(this)
        override fun body(body: ByteArray): FluentBuilder = apply { this.body = body }
        override fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder = apply { this.failOnWarnings = failOnWarnings }
        override fun mode(mode: PutMode): FluentBuilder = apply { this.mode = mode }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
    }
}
