// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The POST request to import API keys from an external source, such as a CSV-formatted file.
 */
class ImportApiKeysRequest private constructor(builder: BuilderImpl) {
    /**
     * The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format.
     */
    val body: ByteArray? = builder.body
    /**
     * A query parameter to indicate whether to rollback ApiKey importation (true) or not (false) when error is encountered.
     */
    val failOnWarnings: Boolean = builder.failOnWarnings
    /**
     * A query parameter to specify the input format to imported API keys. Currently, only the csv format is supported.
     */
    val format: ApiKeysFormat? = builder.format

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportApiKeysRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportApiKeysRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("format=$format)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (format?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportApiKeysRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (format != other.format) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportApiKeysRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportApiKeysRequest
        /**
         * The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format.
         */
        fun body(body: ByteArray): FluentBuilder
        /**
         * A query parameter to indicate whether to rollback ApiKey importation (true) or not (false) when error is encountered.
         */
        fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder
        /**
         * A query parameter to specify the input format to imported API keys. Currently, only the csv format is supported.
         */
        fun format(format: ApiKeysFormat): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format.
         */
        var body: ByteArray?
        /**
         * A query parameter to indicate whether to rollback ApiKey importation (true) or not (false) when error is encountered.
         */
        var failOnWarnings: Boolean
        /**
         * A query parameter to specify the input format to imported API keys. Currently, only the csv format is supported.
         */
        var format: ApiKeysFormat?

        fun build(): ImportApiKeysRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var body: ByteArray? = null
        override var failOnWarnings: Boolean = false
        override var format: ApiKeysFormat? = null

        constructor(x: ImportApiKeysRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.format = x.format
        }

        override fun build(): ImportApiKeysRequest = ImportApiKeysRequest(this)
        override fun body(body: ByteArray): FluentBuilder = apply { this.body = body }
        override fun failOnWarnings(failOnWarnings: Boolean): FluentBuilder = apply { this.failOnWarnings = failOnWarnings }
        override fun format(format: ApiKeysFormat): FluentBuilder = apply { this.format = format }
    }
}
