// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * An API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 * <div class="remarks">
 * To enable access to a resource in an Amazon Virtual Private Cloud through Amazon API Gateway, you, as an API developer, create a VpcLink resource targeted for one or more network load balancers of the VPC and then integrate an API method with a private integration that uses the VpcLink. The private integration has an integration type of HTTP or HTTP_PROXY and has a connection type of VPC_LINK. The integration uses the connectionId property to identify the VpcLink used.
 * </div>
 */
class GetVpcLinkResponse private constructor(builder: BuilderImpl) {
    /**
     * The description of the VPC link.
     */
    val description: String? = builder.description
    /**
     * The identifier of the  VpcLink. It is used in an Integration to reference this VpcLink.
     */
    val id: String? = builder.id
    /**
     * The name used to label and identify the VPC link.
     */
    val name: String? = builder.name
    /**
     * The status of the VPC link. The valid values are AVAILABLE, PENDING, DELETING, or FAILED. Deploying an API will wait if the status is PENDING and will fail if the status is DELETING.
     */
    val status: VpcLinkStatus? = builder.status
    /**
     * A description about the VPC link status.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
     */
    val targetArns: List<String>? = builder.targetArns

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetVpcLinkResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetVpcLinkResponse(")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags,")
        append("targetArns=$targetArns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetVpcLinkResponse

        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false
        if (targetArns != other.targetArns) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetVpcLinkResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetVpcLinkResponse
        /**
         * The description of the VPC link.
         */
        fun description(description: String): FluentBuilder
        /**
         * The identifier of the  VpcLink. It is used in an Integration to reference this VpcLink.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name used to label and identify the VPC link.
         */
        fun name(name: String): FluentBuilder
        /**
         * The status of the VPC link. The valid values are AVAILABLE, PENDING, DELETING, or FAILED. Deploying an API will wait if the status is PENDING and will fail if the status is DELETING.
         */
        fun status(status: VpcLinkStatus): FluentBuilder
        /**
         * A description about the VPC link status.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
         */
        fun targetArns(targetArns: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the VPC link.
         */
        var description: String?
        /**
         * The identifier of the  VpcLink. It is used in an Integration to reference this VpcLink.
         */
        var id: String?
        /**
         * The name used to label and identify the VPC link.
         */
        var name: String?
        /**
         * The status of the VPC link. The valid values are AVAILABLE, PENDING, DELETING, or FAILED. Deploying an API will wait if the status is PENDING and will fail if the status is DELETING.
         */
        var status: VpcLinkStatus?
        /**
         * A description about the VPC link status.
         */
        var statusMessage: String?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?
        /**
         * The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
         */
        var targetArns: List<String>?

        fun build(): GetVpcLinkResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var id: String? = null
        override var name: String? = null
        override var status: VpcLinkStatus? = null
        override var statusMessage: String? = null
        override var tags: Map<String, String>? = null
        override var targetArns: List<String>? = null

        constructor(x: GetVpcLinkResponse) : this() {
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
            this.targetArns = x.targetArns
        }

        override fun build(): GetVpcLinkResponse = GetVpcLinkResponse(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun status(status: VpcLinkStatus): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targetArns(targetArns: List<String>): FluentBuilder = apply { this.targetArns = targetArns }
    }
}
