// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The GET request to get the usage data of a usage plan in a specified time interval.
 */
class GetUsageRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; The ending date (e.g., 2016-12-31) of the usage data.
     */
    val endDate: String? = builder.endDate
    /**
     * The Id of the API key associated with the resultant usage data.
     */
    val keyId: String? = builder.keyId
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    val limit: Int? = builder.limit
    /**
     * The current pagination position in the paged result set.
     */
    val position: String? = builder.position
    /**
     * &#91;Required&#93; The starting date (e.g., 2016-01-01) of the usage data.
     */
    val startDate: String? = builder.startDate
    /**
     * &#91;Required&#93; The Id of the usage plan associated with the usage data.
     */
    val usagePlanId: String? = builder.usagePlanId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetUsageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetUsageRequest(")
        append("endDate=$endDate,")
        append("keyId=$keyId,")
        append("limit=$limit,")
        append("position=$position,")
        append("startDate=$startDate,")
        append("usagePlanId=$usagePlanId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (usagePlanId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetUsageRequest

        if (endDate != other.endDate) return false
        if (keyId != other.keyId) return false
        if (limit != other.limit) return false
        if (position != other.position) return false
        if (startDate != other.startDate) return false
        if (usagePlanId != other.usagePlanId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetUsageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetUsageRequest
        /**
         * &#91;Required&#93; The ending date (e.g., 2016-12-31) of the usage data.
         */
        fun endDate(endDate: String): FluentBuilder
        /**
         * The Id of the API key associated with the resultant usage data.
         */
        fun keyId(keyId: String): FluentBuilder
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The current pagination position in the paged result set.
         */
        fun position(position: String): FluentBuilder
        /**
         * &#91;Required&#93; The starting date (e.g., 2016-01-01) of the usage data.
         */
        fun startDate(startDate: String): FluentBuilder
        /**
         * &#91;Required&#93; The Id of the usage plan associated with the usage data.
         */
        fun usagePlanId(usagePlanId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; The ending date (e.g., 2016-12-31) of the usage data.
         */
        var endDate: String?
        /**
         * The Id of the API key associated with the resultant usage data.
         */
        var keyId: String?
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        var limit: Int?
        /**
         * The current pagination position in the paged result set.
         */
        var position: String?
        /**
         * &#91;Required&#93; The starting date (e.g., 2016-01-01) of the usage data.
         */
        var startDate: String?
        /**
         * &#91;Required&#93; The Id of the usage plan associated with the usage data.
         */
        var usagePlanId: String?

        fun build(): GetUsageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endDate: String? = null
        override var keyId: String? = null
        override var limit: Int? = null
        override var position: String? = null
        override var startDate: String? = null
        override var usagePlanId: String? = null

        constructor(x: GetUsageRequest) : this() {
            this.endDate = x.endDate
            this.keyId = x.keyId
            this.limit = x.limit
            this.position = x.position
            this.startDate = x.startDate
            this.usagePlanId = x.usagePlanId
        }

        override fun build(): GetUsageRequest = GetUsageRequest(this)
        override fun endDate(endDate: String): FluentBuilder = apply { this.endDate = endDate }
        override fun keyId(keyId: String): FluentBuilder = apply { this.keyId = keyId }
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
        override fun startDate(startDate: String): FluentBuilder = apply { this.startDate = startDate }
        override fun usagePlanId(usagePlanId: String): FluentBuilder = apply { this.usagePlanId = usagePlanId }
    }
}
