// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to list information about a collection of resources.
 */
class GetResourcesRequest private constructor(builder: BuilderImpl) {
    /**
     * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response.  This embed parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the "methods" string. For example, GET /restapis/{restapi_id}/resources?embed=methods.
     */
    val embed: List<String>? = builder.embed
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    val limit: Int? = builder.limit
    /**
     * The current pagination position in the paged result set.
     */
    val position: String? = builder.position
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetResourcesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetResourcesRequest(")
        append("embed=$embed,")
        append("limit=$limit,")
        append("position=$position,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = embed?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetResourcesRequest

        if (embed != other.embed) return false
        if (limit != other.limit) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetResourcesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetResourcesRequest
        /**
         * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response.  This embed parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the "methods" string. For example, GET /restapis/{restapi_id}/resources?embed=methods.
         */
        fun embed(embed: List<String>): FluentBuilder
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The current pagination position in the paged result set.
         */
        fun position(position: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response.  This embed parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the "methods" string. For example, GET /restapis/{restapi_id}/resources?embed=methods.
         */
        var embed: List<String>?
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        var limit: Int?
        /**
         * The current pagination position in the paged result set.
         */
        var position: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?

        fun build(): GetResourcesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var embed: List<String>? = null
        override var limit: Int? = null
        override var position: String? = null
        override var restApiId: String? = null

        constructor(x: GetResourcesRequest) : this() {
            this.embed = x.embed
            this.limit = x.limit
            this.position = x.position
            this.restApiId = x.restApiId
        }

        override fun build(): GetResourcesRequest = GetResourcesRequest(this)
        override fun embed(embed: List<String>): FluentBuilder = apply { this.embed = embed }
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
    }
}
