// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a client-facing interface by which the client calls the API to access back-end resources. A Method resource is
 * integrated with an Integration resource. Both consist of a request and one or more responses. The method request takes
 * the client input that is passed to the back end through the integration request. A method response returns the output from
 * the back end to the client through an integration response. A method request is embodied in a Method resource, whereas
 * an integration request is embodied in an Integration resource.  On the other hand, a method response is represented
 * by a MethodResponse resource, whereas an integration response is represented by an IntegrationResponse resource.
 * <div class="remarks">
 * <h4>Example: Retrive the GET method on a specified resource</h4>
 * <h5>Request</h5>
 * The following example request retrieves the information about the GET method on an API resource (3kzxbg5sa2) of an API (fugvjdxtri).
 * <pre>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
 * Content-Type: application/json
 * Host: apigateway.us-east-1.amazonaws.com
 * X-Amz-Date: 20160603T210259Z
 * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
 * <h5>Response</h5>
 * The successful response returns a 200 OK status code and a payload similar to the following:
 * <pre>{
 * "_links": {
 * "curies": &#91;
 * {
 * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
 * "name": "integration",
 * "templated": true
 * },
 * {
 * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
 * "name": "integrationresponse",
 * "templated": true
 * },
 * {
 * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
 * "name": "method",
 * "templated": true
 * },
 * {
 * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
 * "name": "methodresponse",
 * "templated": true
 * }
 * &#93;,
 * "self": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
 * "name": "GET",
 * "title": "GET"
 * },
 * "integration:put": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
 * },
 * "method:delete": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
 * },
 * "method:integration": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
 * },
 * "method:responses": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
 * "name": "200",
 * "title": "200"
 * },
 * "method:update": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
 * },
 * "methodresponse:put": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
 * "templated": true
 * }
 * },
 * "apiKeyRequired": true,
 * "authorizationType": "NONE",
 * "httpMethod": "GET",
 * "_embedded": {
 * "method:integration": {
 * "_links": {
 * "self": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
 * },
 * "integration:delete": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
 * },
 * "integration:responses": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
 * "name": "200",
 * "title": "200"
 * },
 * "integration:update": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
 * },
 * "integrationresponse:put": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
 * "templated": true
 * }
 * },
 * "cacheKeyParameters": &#91;&#93;,
 * "cacheNamespace": "3kzxbg5sa2",
 * "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
 * "httpMethod": "POST",
 * "passthroughBehavior": "WHEN_NO_MATCH",
 * "requestParameters": {
 * "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
 * },
 * "requestTemplates": {
 * "application/json": "{\n}"
 * },
 * "type": "AWS",
 * "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
 * "_embedded": {
 * "integration:responses": {
 * "_links": {
 * "self": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
 * "name": "200",
 * "title": "200"
 * },
 * "integrationresponse:delete": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
 * },
 * "integrationresponse:update": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
 * }
 * },
 * "responseParameters": {
 * "method.response.header.Content-Type": "'application/xml'"
 * },
 * "responseTemplates": {
 * "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
 * },
 * "statusCode": "200"
 * }
 * }
 * },
 * "method:responses": {
 * "_links": {
 * "self": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
 * "name": "200",
 * "title": "200"
 * },
 * "methodresponse:delete": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
 * },
 * "methodresponse:update": {
 * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
 * }
 * },
 * "responseModels": {
 * "application/json": "Empty"
 * },
 * "responseParameters": {
 * "method.response.header.Content-Type": false
 * },
 * "statusCode": "200"
 * }
 * }
 * }</pre>
 * In the example above, the response template for the 200 OK response maps the JSON output from the ListStreams action in the back end to an XML output. The mapping template is URL-encoded as %3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E and the output is decoded using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference">$util.urlDecode() helper function.
 * </div>
 * <div class="seeAlso">
 * MethodResponse, Integration, IntegrationResponse, Resource,
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html">Set up an API's method
 * </div>
 */
class GetMethodResponse private constructor(builder: BuilderImpl) {
    /**
     * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
     */
    val apiKeyRequired: Boolean? = builder.apiKeyRequired
    /**
     * A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    val authorizationScopes: List<String>? = builder.authorizationScopes
    /**
     * The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
     */
    val authorizationType: String? = builder.authorizationType
    /**
     * The identifier of an Authorizer to use on this method. The authorizationType must be CUSTOM.
     */
    val authorizerId: String? = builder.authorizerId
    /**
     * The method's HTTP verb.
     */
    val httpMethod: String? = builder.httpMethod
    /**
     * Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.
     * <div class="remarks">
     * <h4>Example: </h4>
     * <h5>Request</h5>
     * <pre>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
     * Content-Type: application/json
     * Host: apigateway.us-east-1.amazonaws.com
     * Content-Length: 117
     * X-Amz-Date: 20160613T213210Z
     * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
     * <h5>Response</h5>
     * The successful response returns a 200 OK status code and a payload similar to the following:
     * <pre>{
     * "_links": {
     * "curies": &#91;
     * {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
     * "name": "integration",
     * "templated": true
     * },
     * {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
     * "name": "integrationresponse",
     * "templated": true
     * }
     * &#93;,
     * "self": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
     * },
     * "integration:delete": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
     * },
     * "integration:responses": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
     * "name": "200",
     * "title": "200"
     * },
     * "integration:update": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
     * },
     * "integrationresponse:put": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
     * "templated": true
     * }
     * },
     * "cacheKeyParameters": &#91;&#93;,
     * "cacheNamespace": "0cjtch",
     * "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
     * "httpMethod": "POST",
     * "passthroughBehavior": "WHEN_NO_MATCH",
     * "requestTemplates": {
     * "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
     * },
     * "type": "AWS",
     * "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
     * "_embedded": {
     * "integration:responses": {
     * "_links": {
     * "self": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
     * "name": "200",
     * "title": "200"
     * },
     * "integrationresponse:delete": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
     * },
     * "integrationresponse:update": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
     * }
     * },
     * "responseParameters": {
     * "method.response.header.operator": "integration.response.body.op",
     * "method.response.header.operand_2": "integration.response.body.b",
     * "method.response.header.operand_1": "integration.response.body.a"
     * },
     * "responseTemplates": {
     * "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
     * },
     * "selectionPattern": "",
     * "statusCode": "200"
     * }
     * }
     * }</pre>
     * </div>
     * <div class="seeAlso">
     * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI
     * </div>
     */
    val methodIntegration: Integration? = builder.methodIntegration
    /**
     * Gets a method response associated with a given HTTP status code.
     * <div class="remarks">
     * The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a MethodResponse resource that specifies the response returned to the caller from the back end through the integration response.
     * <h4>Example: Get a 200 OK response of a GET method</h4>
     * <h5>Request</h5>
     * <pre>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
     * Content-Type: application/json
     * Host: apigateway.us-east-1.amazonaws.com
     * Content-Length: 117
     * X-Amz-Date: 20160613T215008Z
     * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
     * <h5>Response</h5>
     * The successful response returns a 200 OK status code and a payload similar to the following:
     * <pre>{
     * "_links": {
     * "curies": {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
     * "name": "methodresponse",
     * "templated": true
     * },
     * "self": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
     * "title": "200"
     * },
     * "methodresponse:delete": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
     * },
     * "methodresponse:update": {
     * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
     * }
     * },
     * "responseModels": {
     * "application/json": "Empty"
     * },
     * "responseParameters": {
     * "method.response.header.operator": false,
     * "method.response.header.operand_2": false,
     * "method.response.header.operand_1": false
     * },
     * "statusCode": "200"
     * }</pre>
     * </div>
     * <div class="seeAlso">
     * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI
     * </div>
     */
    val methodResponses: Map<String, MethodResponse>? = builder.methodResponses
    /**
     * A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example.
     */
    val operationName: String? = builder.operationName
    /**
     * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
     */
    val requestModels: Map<String, String>? = builder.requestModels
    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false).  The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
     */
    val requestParameters: Map<String, Boolean>? = builder.requestParameters
    /**
     * The identifier of a RequestValidator for request validation.
     */
    val requestValidatorId: String? = builder.requestValidatorId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetMethodResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetMethodResponse(")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationScopes=$authorizationScopes,")
        append("authorizationType=$authorizationType,")
        append("authorizerId=$authorizerId,")
        append("httpMethod=$httpMethod,")
        append("methodIntegration=$methodIntegration,")
        append("methodResponses=$methodResponses,")
        append("operationName=$operationName,")
        append("requestModels=$requestModels,")
        append("requestParameters=$requestParameters,")
        append("requestValidatorId=$requestValidatorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyRequired?.hashCode() ?: 0
        result = 31 * result + (authorizationScopes?.hashCode() ?: 0)
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (methodIntegration?.hashCode() ?: 0)
        result = 31 * result + (methodResponses?.hashCode() ?: 0)
        result = 31 * result + (operationName?.hashCode() ?: 0)
        result = 31 * result + (requestModels?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestValidatorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetMethodResponse

        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationScopes != other.authorizationScopes) return false
        if (authorizationType != other.authorizationType) return false
        if (authorizerId != other.authorizerId) return false
        if (httpMethod != other.httpMethod) return false
        if (methodIntegration != other.methodIntegration) return false
        if (methodResponses != other.methodResponses) return false
        if (operationName != other.operationName) return false
        if (requestModels != other.requestModels) return false
        if (requestParameters != other.requestParameters) return false
        if (requestValidatorId != other.requestValidatorId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetMethodResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetMethodResponse
        /**
         * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         */
        fun apiKeyRequired(apiKeyRequired: Boolean): FluentBuilder
        /**
         * A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        fun authorizationScopes(authorizationScopes: List<String>): FluentBuilder
        /**
         * The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
         */
        fun authorizationType(authorizationType: String): FluentBuilder
        /**
         * The identifier of an Authorizer to use on this method. The authorizationType must be CUSTOM.
         */
        fun authorizerId(authorizerId: String): FluentBuilder
        /**
         * The method's HTTP verb.
         */
        fun httpMethod(httpMethod: String): FluentBuilder
        /**
         * Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.
         * <div class="remarks">
         * <h4>Example: </h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * Content-Length: 117
         * X-Amz-Date: 20160613T213210Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
         * <h5>Response</h5>
         * The successful response returns a 200 OK status code and a payload similar to the following:
         * <pre>{
         * "_links": {
         * "curies": &#91;
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
         * "name": "integration",
         * "templated": true
         * },
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
         * "name": "integrationresponse",
         * "templated": true
         * }
         * &#93;,
         * "self": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
         * },
         * "integration:delete": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
         * },
         * "integration:responses": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "integration:update": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
         * },
         * "integrationresponse:put": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
         * "templated": true
         * }
         * },
         * "cacheKeyParameters": &#91;&#93;,
         * "cacheNamespace": "0cjtch",
         * "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
         * "httpMethod": "POST",
         * "passthroughBehavior": "WHEN_NO_MATCH",
         * "requestTemplates": {
         * "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
         * },
         * "type": "AWS",
         * "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
         * "_embedded": {
         * "integration:responses": {
         * "_links": {
         * "self": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "integrationresponse:delete": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
         * },
         * "integrationresponse:update": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
         * }
         * },
         * "responseParameters": {
         * "method.response.header.operator": "integration.response.body.op",
         * "method.response.header.operand_2": "integration.response.body.b",
         * "method.response.header.operand_1": "integration.response.body.a"
         * },
         * "responseTemplates": {
         * "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
         * },
         * "selectionPattern": "",
         * "statusCode": "200"
         * }
         * }
         * }</pre>
         * </div>
         * <div class="seeAlso">
         * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI
         * </div>
         */
        fun methodIntegration(methodIntegration: Integration): FluentBuilder
        /**
         * Gets a method response associated with a given HTTP status code.
         * <div class="remarks">
         * The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a MethodResponse resource that specifies the response returned to the caller from the back end through the integration response.
         * <h4>Example: Get a 200 OK response of a GET method</h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * Content-Length: 117
         * X-Amz-Date: 20160613T215008Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
         * <h5>Response</h5>
         * The successful response returns a 200 OK status code and a payload similar to the following:
         * <pre>{
         * "_links": {
         * "curies": {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
         * "name": "methodresponse",
         * "templated": true
         * },
         * "self": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
         * "title": "200"
         * },
         * "methodresponse:delete": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
         * },
         * "methodresponse:update": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
         * }
         * },
         * "responseModels": {
         * "application/json": "Empty"
         * },
         * "responseParameters": {
         * "method.response.header.operator": false,
         * "method.response.header.operand_2": false,
         * "method.response.header.operand_1": false
         * },
         * "statusCode": "200"
         * }</pre>
         * </div>
         * <div class="seeAlso">
         * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI
         * </div>
         */
        fun methodResponses(methodResponses: Map<String, MethodResponse>): FluentBuilder
        /**
         * A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example.
         */
        fun operationName(operationName: String): FluentBuilder
        /**
         * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         */
        fun requestModels(requestModels: Map<String, String>): FluentBuilder
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false).  The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         */
        fun requestParameters(requestParameters: Map<String, Boolean>): FluentBuilder
        /**
         * The identifier of a RequestValidator for request validation.
         */
        fun requestValidatorId(requestValidatorId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         */
        var apiKeyRequired: Boolean?
        /**
         * A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        var authorizationScopes: List<String>?
        /**
         * The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
         */
        var authorizationType: String?
        /**
         * The identifier of an Authorizer to use on this method. The authorizationType must be CUSTOM.
         */
        var authorizerId: String?
        /**
         * The method's HTTP verb.
         */
        var httpMethod: String?
        /**
         * Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.
         * <div class="remarks">
         * <h4>Example: </h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * Content-Length: 117
         * X-Amz-Date: 20160613T213210Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
         * <h5>Response</h5>
         * The successful response returns a 200 OK status code and a payload similar to the following:
         * <pre>{
         * "_links": {
         * "curies": &#91;
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
         * "name": "integration",
         * "templated": true
         * },
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
         * "name": "integrationresponse",
         * "templated": true
         * }
         * &#93;,
         * "self": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
         * },
         * "integration:delete": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
         * },
         * "integration:responses": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "integration:update": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
         * },
         * "integrationresponse:put": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
         * "templated": true
         * }
         * },
         * "cacheKeyParameters": &#91;&#93;,
         * "cacheNamespace": "0cjtch",
         * "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
         * "httpMethod": "POST",
         * "passthroughBehavior": "WHEN_NO_MATCH",
         * "requestTemplates": {
         * "application/json": "{\n    \"a\":  \"$input.params('operand1')\",\n    \"b\":  \"$input.params('operand2')\", \n    \"op\": \"$input.params('operator')\"   \n}"
         * },
         * "type": "AWS",
         * "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
         * "_embedded": {
         * "integration:responses": {
         * "_links": {
         * "self": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "integrationresponse:delete": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
         * },
         * "integrationresponse:update": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
         * }
         * },
         * "responseParameters": {
         * "method.response.header.operator": "integration.response.body.op",
         * "method.response.header.operand_2": "integration.response.body.b",
         * "method.response.header.operand_1": "integration.response.body.a"
         * },
         * "responseTemplates": {
         * "application/json": "#set($res = $input.path('$'))\n{\n    \"result\": \"$res.a, $res.b, $res.op => $res.c\",\n  \"a\" : \"$res.a\",\n  \"b\" : \"$res.b\",\n  \"op\" : \"$res.op\",\n  \"c\" : \"$res.c\"\n}"
         * },
         * "selectionPattern": "",
         * "statusCode": "200"
         * }
         * }
         * }</pre>
         * </div>
         * <div class="seeAlso">
         * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI
         * </div>
         */
        var methodIntegration: Integration?
        /**
         * Gets a method response associated with a given HTTP status code.
         * <div class="remarks">
         * The collection of method responses are encapsulated in a key-value map, where the key is a response's HTTP status code and the value is a MethodResponse resource that specifies the response returned to the caller from the back end through the integration response.
         * <h4>Example: Get a 200 OK response of a GET method</h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * Content-Length: 117
         * X-Amz-Date: 20160613T215008Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
         * <h5>Response</h5>
         * The successful response returns a 200 OK status code and a payload similar to the following:
         * <pre>{
         * "_links": {
         * "curies": {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
         * "name": "methodresponse",
         * "templated": true
         * },
         * "self": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
         * "title": "200"
         * },
         * "methodresponse:delete": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
         * },
         * "methodresponse:update": {
         * "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
         * }
         * },
         * "responseModels": {
         * "application/json": "Empty"
         * },
         * "responseParameters": {
         * "method.response.header.operator": false,
         * "method.response.header.operand_2": false,
         * "method.response.header.operand_1": false
         * },
         * "statusCode": "200"
         * }</pre>
         * </div>
         * <div class="seeAlso">
         * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI
         * </div>
         */
        var methodResponses: Map<String, MethodResponse>?
        /**
         * A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example.
         */
        var operationName: String?
        /**
         * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         */
        var requestModels: Map<String, String>?
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of  method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false).  The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         */
        var requestParameters: Map<String, Boolean>?
        /**
         * The identifier of a RequestValidator for request validation.
         */
        var requestValidatorId: String?

        fun build(): GetMethodResponse
        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.Integration] inside the given [block]
         */
        fun methodIntegration(block: Integration.DslBuilder.() -> kotlin.Unit) {
            this.methodIntegration = Integration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiKeyRequired: Boolean? = null
        override var authorizationScopes: List<String>? = null
        override var authorizationType: String? = null
        override var authorizerId: String? = null
        override var httpMethod: String? = null
        override var methodIntegration: Integration? = null
        override var methodResponses: Map<String, MethodResponse>? = null
        override var operationName: String? = null
        override var requestModels: Map<String, String>? = null
        override var requestParameters: Map<String, Boolean>? = null
        override var requestValidatorId: String? = null

        constructor(x: GetMethodResponse) : this() {
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationScopes = x.authorizationScopes
            this.authorizationType = x.authorizationType
            this.authorizerId = x.authorizerId
            this.httpMethod = x.httpMethod
            this.methodIntegration = x.methodIntegration
            this.methodResponses = x.methodResponses
            this.operationName = x.operationName
            this.requestModels = x.requestModels
            this.requestParameters = x.requestParameters
            this.requestValidatorId = x.requestValidatorId
        }

        override fun build(): GetMethodResponse = GetMethodResponse(this)
        override fun apiKeyRequired(apiKeyRequired: Boolean): FluentBuilder = apply { this.apiKeyRequired = apiKeyRequired }
        override fun authorizationScopes(authorizationScopes: List<String>): FluentBuilder = apply { this.authorizationScopes = authorizationScopes }
        override fun authorizationType(authorizationType: String): FluentBuilder = apply { this.authorizationType = authorizationType }
        override fun authorizerId(authorizerId: String): FluentBuilder = apply { this.authorizerId = authorizerId }
        override fun httpMethod(httpMethod: String): FluentBuilder = apply { this.httpMethod = httpMethod }
        override fun methodIntegration(methodIntegration: Integration): FluentBuilder = apply { this.methodIntegration = methodIntegration }
        override fun methodResponses(methodResponses: Map<String, MethodResponse>): FluentBuilder = apply { this.methodResponses = methodResponses }
        override fun operationName(operationName: String): FluentBuilder = apply { this.operationName = operationName }
        override fun requestModels(requestModels: Map<String, String>): FluentBuilder = apply { this.requestModels = requestModels }
        override fun requestParameters(requestParameters: Map<String, Boolean>): FluentBuilder = apply { this.requestParameters = requestParameters }
        override fun requestValidatorId(requestValidatorId: String): FluentBuilder = apply { this.requestValidatorId = requestValidatorId }
    }
}
