// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.
 */
class GetGatewayResponsesRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The GatewayResponses collection does not support pagination and the limit does not apply here.
     */
    val limit: Int? = builder.limit
    /**
     * The current pagination position in the paged result set. The GatewayResponse collection does not support pagination and the position does not apply here.
     */
    val position: String? = builder.position
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetGatewayResponsesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetGatewayResponsesRequest(")
        append("limit=$limit,")
        append("position=$position,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetGatewayResponsesRequest

        if (limit != other.limit) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetGatewayResponsesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetGatewayResponsesRequest
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The GatewayResponses collection does not support pagination and the limit does not apply here.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The current pagination position in the paged result set. The GatewayResponse collection does not support pagination and the position does not apply here.
         */
        fun position(position: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The GatewayResponses collection does not support pagination and the limit does not apply here.
         */
        var limit: Int?
        /**
         * The current pagination position in the paged result set. The GatewayResponse collection does not support pagination and the position does not apply here.
         */
        var position: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?

        fun build(): GetGatewayResponsesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var limit: Int? = null
        override var position: String? = null
        override var restApiId: String? = null

        constructor(x: GetGatewayResponsesRequest) : this() {
            this.limit = x.limit
            this.position = x.position
            this.restApiId = x.restApiId
        }

        override fun build(): GetGatewayResponsesRequest = GetGatewayResponsesRequest(this)
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
    }
}
