// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request a new export of a RestApi for a particular Stage.
 */
class GetExportRequest private constructor(builder: BuilderImpl) {
    /**
     * The content-type of the export, for example application/json. Currently application/json and application/yaml are supported for exportType ofoas30 and swagger. This should be specified in the Accept header for direct API requests.
     */
    val accepts: String? = builder.accepts
    /**
     * &#91;Required&#93; The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
     */
    val exportType: String? = builder.exportType
    /**
     * A key-value map of query string parameters that specify properties of the export, depending on the requested exportType. For exportType oas30 and swagger, any combination of the following parameters are supported: extensions='integrations' or extensions='apigateway' will export the API with x-amazon-apigateway-integration extensions. extensions='authorizers' will export the API with  x-amazon-apigateway-authorizer extensions. postman will export the API with Postman extensions, allowing for import to the Postman tool
     */
    val parameters: Map<String, String>? = builder.parameters
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * &#91;Required&#93; The name of the Stage that will be exported.
     */
    val stageName: String? = builder.stageName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetExportRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetExportRequest(")
        append("accepts=$accepts,")
        append("exportType=$exportType,")
        append("parameters=$parameters,")
        append("restApiId=$restApiId,")
        append("stageName=$stageName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accepts?.hashCode() ?: 0
        result = 31 * result + (exportType?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetExportRequest

        if (accepts != other.accepts) return false
        if (exportType != other.exportType) return false
        if (parameters != other.parameters) return false
        if (restApiId != other.restApiId) return false
        if (stageName != other.stageName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetExportRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetExportRequest
        /**
         * The content-type of the export, for example application/json. Currently application/json and application/yaml are supported for exportType ofoas30 and swagger. This should be specified in the Accept header for direct API requests.
         */
        fun accepts(accepts: String): FluentBuilder
        /**
         * &#91;Required&#93; The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
         */
        fun exportType(exportType: String): FluentBuilder
        /**
         * A key-value map of query string parameters that specify properties of the export, depending on the requested exportType. For exportType oas30 and swagger, any combination of the following parameters are supported: extensions='integrations' or extensions='apigateway' will export the API with x-amazon-apigateway-integration extensions. extensions='authorizers' will export the API with  x-amazon-apigateway-authorizer extensions. postman will export the API with Postman extensions, allowing for import to the Postman tool
         */
        fun parameters(parameters: Map<String, String>): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * &#91;Required&#93; The name of the Stage that will be exported.
         */
        fun stageName(stageName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The content-type of the export, for example application/json. Currently application/json and application/yaml are supported for exportType ofoas30 and swagger. This should be specified in the Accept header for direct API requests.
         */
        var accepts: String?
        /**
         * &#91;Required&#93; The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
         */
        var exportType: String?
        /**
         * A key-value map of query string parameters that specify properties of the export, depending on the requested exportType. For exportType oas30 and swagger, any combination of the following parameters are supported: extensions='integrations' or extensions='apigateway' will export the API with x-amazon-apigateway-integration extensions. extensions='authorizers' will export the API with  x-amazon-apigateway-authorizer extensions. postman will export the API with Postman extensions, allowing for import to the Postman tool
         */
        var parameters: Map<String, String>?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * &#91;Required&#93; The name of the Stage that will be exported.
         */
        var stageName: String?

        fun build(): GetExportRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accepts: String? = null
        override var exportType: String? = null
        override var parameters: Map<String, String>? = null
        override var restApiId: String? = null
        override var stageName: String? = null

        constructor(x: GetExportRequest) : this() {
            this.accepts = x.accepts
            this.exportType = x.exportType
            this.parameters = x.parameters
            this.restApiId = x.restApiId
            this.stageName = x.stageName
        }

        override fun build(): GetExportRequest = GetExportRequest(this)
        override fun accepts(accepts: String): FluentBuilder = apply { this.accepts = accepts }
        override fun exportType(exportType: String): FluentBuilder = apply { this.exportType = exportType }
        override fun parameters(parameters: Map<String, String>): FluentBuilder = apply { this.parameters = parameters }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun stageName(stageName: String): FluentBuilder = apply { this.stageName = stageName }
    }
}
