// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API entities (targets).
 */
class GetDocumentationPartsRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    val limit: Int? = builder.limit
    /**
     * The status of the API documentation parts to retrieve. Valid values are DOCUMENTED for retrieving DocumentationPart resources with content and UNDOCUMENTED for DocumentationPart resources without content.
     */
    val locationStatus: LocationStatusType? = builder.locationStatus
    /**
     * The name of API entities of the to-be-retrieved documentation parts.
     */
    val nameQuery: String? = builder.nameQuery
    /**
     * The path of API entities of the to-be-retrieved documentation parts.
     */
    val path: String? = builder.path
    /**
     * The current pagination position in the paged result set.
     */
    val position: String? = builder.position
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId
    /**
     * The type of API entities of the to-be-retrieved documentation parts.
     */
    val type: DocumentationPartType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetDocumentationPartsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetDocumentationPartsRequest(")
        append("limit=$limit,")
        append("locationStatus=$locationStatus,")
        append("nameQuery=$nameQuery,")
        append("path=$path,")
        append("position=$position,")
        append("restApiId=$restApiId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (locationStatus?.hashCode() ?: 0)
        result = 31 * result + (nameQuery?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetDocumentationPartsRequest

        if (limit != other.limit) return false
        if (locationStatus != other.locationStatus) return false
        if (nameQuery != other.nameQuery) return false
        if (path != other.path) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetDocumentationPartsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetDocumentationPartsRequest
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        fun limit(limit: Int): FluentBuilder
        /**
         * The status of the API documentation parts to retrieve. Valid values are DOCUMENTED for retrieving DocumentationPart resources with content and UNDOCUMENTED for DocumentationPart resources without content.
         */
        fun locationStatus(locationStatus: LocationStatusType): FluentBuilder
        /**
         * The name of API entities of the to-be-retrieved documentation parts.
         */
        fun nameQuery(nameQuery: String): FluentBuilder
        /**
         * The path of API entities of the to-be-retrieved documentation parts.
         */
        fun path(path: String): FluentBuilder
        /**
         * The current pagination position in the paged result set.
         */
        fun position(position: String): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
        /**
         * The type of API entities of the to-be-retrieved documentation parts.
         */
        fun type(type: DocumentationPartType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        var limit: Int?
        /**
         * The status of the API documentation parts to retrieve. Valid values are DOCUMENTED for retrieving DocumentationPart resources with content and UNDOCUMENTED for DocumentationPart resources without content.
         */
        var locationStatus: LocationStatusType?
        /**
         * The name of API entities of the to-be-retrieved documentation parts.
         */
        var nameQuery: String?
        /**
         * The path of API entities of the to-be-retrieved documentation parts.
         */
        var path: String?
        /**
         * The current pagination position in the paged result set.
         */
        var position: String?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?
        /**
         * The type of API entities of the to-be-retrieved documentation parts.
         */
        var type: DocumentationPartType?

        fun build(): GetDocumentationPartsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var limit: Int? = null
        override var locationStatus: LocationStatusType? = null
        override var nameQuery: String? = null
        override var path: String? = null
        override var position: String? = null
        override var restApiId: String? = null
        override var type: DocumentationPartType? = null

        constructor(x: GetDocumentationPartsRequest) : this() {
            this.limit = x.limit
            this.locationStatus = x.locationStatus
            this.nameQuery = x.nameQuery
            this.path = x.path
            this.position = x.position
            this.restApiId = x.restApiId
            this.type = x.type
        }

        override fun build(): GetDocumentationPartsRequest = GetDocumentationPartsRequest(this)
        override fun limit(limit: Int): FluentBuilder = apply { this.limit = limit }
        override fun locationStatus(locationStatus: LocationStatusType): FluentBuilder = apply { this.locationStatus = locationStatus }
        override fun nameQuery(nameQuery: String): FluentBuilder = apply { this.nameQuery = nameQuery }
        override fun path(path: String): FluentBuilder = apply { this.path = path }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
        override fun type(type: DocumentationPartType): FluentBuilder = apply { this.type = type }
    }
}
