// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a collection resource that contains zero or more references to your existing deployments, and links that guide you on how to interact with your collection. The collection offers a paginated view of the contained deployments.
 * <div class="remarks">To create a new deployment of a RestApi, make a POST request against this resource. To view, update, or delete an existing
 * deployment, make a GET, PATCH, or DELETE request, respectively, on a specified Deployment resource.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploying an API,
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI,
 * <a href="https://aws.amazon.com/tools/">AWS SDKs
 * </div>
 */
class GetDeploymentsResponse private constructor(builder: BuilderImpl) {
    /**
     * The current page of elements from this collection.
     */
    val items: List<Deployment>? = builder.items
    /**
     * The current pagination position in the paged result set.
     */
    val position: String? = builder.position

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetDeploymentsResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentsResponse(")
        append("items=$items,")
        append("position=$position)")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (position?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetDeploymentsResponse

        if (items != other.items) return false
        if (position != other.position) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetDeploymentsResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetDeploymentsResponse
        /**
         * The current page of elements from this collection.
         */
        fun items(items: List<Deployment>): FluentBuilder
        /**
         * The current pagination position in the paged result set.
         */
        fun position(position: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The current page of elements from this collection.
         */
        var items: List<Deployment>?
        /**
         * The current pagination position in the paged result set.
         */
        var position: String?

        fun build(): GetDeploymentsResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var items: List<Deployment>? = null
        override var position: String? = null

        constructor(x: GetDeploymentsResponse) : this() {
            this.items = x.items
            this.position = x.position
        }

        override fun build(): GetDeploymentsResponse = GetDeploymentsResponse(this)
        override fun items(items: List<Deployment>): FluentBuilder = apply { this.items = items }
        override fun position(position: String): FluentBuilder = apply { this.position = position }
    }
}
