// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to get information about a Deployment resource.
 */
class GetDeploymentRequest private constructor(builder: BuilderImpl) {
    /**
     * &#91;Required&#93; The identifier of the Deployment resource to get information about.
     */
    val deploymentId: String? = builder.deploymentId
    /**
     * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the response. In a REST API call, this embed parameter value is a list of comma-separated strings, as in  GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the "apisummary" string.  For example, GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary.
     */
    val embed: List<String>? = builder.embed
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: String? = builder.restApiId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetDeploymentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentRequest(")
        append("deploymentId=$deploymentId,")
        append("embed=$embed,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (embed?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetDeploymentRequest

        if (deploymentId != other.deploymentId) return false
        if (embed != other.embed) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetDeploymentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetDeploymentRequest
        /**
         * &#91;Required&#93; The identifier of the Deployment resource to get information about.
         */
        fun deploymentId(deploymentId: String): FluentBuilder
        /**
         * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the response. In a REST API call, this embed parameter value is a list of comma-separated strings, as in  GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the "apisummary" string.  For example, GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary.
         */
        fun embed(embed: List<String>): FluentBuilder
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        fun restApiId(restApiId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * &#91;Required&#93; The identifier of the Deployment resource to get information about.
         */
        var deploymentId: String?
        /**
         * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the response. In a REST API call, this embed parameter value is a list of comma-separated strings, as in  GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the "apisummary" string.  For example, GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary.
         */
        var embed: List<String>?
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: String?

        fun build(): GetDeploymentRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deploymentId: String? = null
        override var embed: List<String>? = null
        override var restApiId: String? = null

        constructor(x: GetDeploymentRequest) : this() {
            this.deploymentId = x.deploymentId
            this.embed = x.embed
            this.restApiId = x.restApiId
        }

        override fun build(): GetDeploymentRequest = GetDeploymentRequest(this)
        override fun deploymentId(deploymentId: String): FluentBuilder = apply { this.deploymentId = deploymentId }
        override fun embed(embed: List<String>): FluentBuilder = apply { this.embed = embed }
        override fun restApiId(restApiId: String): FluentBuilder = apply { this.restApiId = restApiId }
    }
}
