// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a client certificate used to configure client-side SSL authentication while sending requests to the integration endpoint.
 * <div class="remarks">Client certificates are used to authenticate an API by the backend server. To authenticate an API client (or user), use IAM roles and policies, a custom Authorizer or an Amazon Cognito user pool.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html">Use Client-Side Certificate
 * </div>
 */
class GetClientCertificateResponse private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the client certificate.
     */
    val clientCertificateId: String? = builder.clientCertificateId
    /**
     * The timestamp when the client certificate was created.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The description of the client certificate.
     */
    val description: String? = builder.description
    /**
     * The timestamp when the client certificate will expire.
     */
    val expirationDate: Instant? = builder.expirationDate
    /**
     * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .
     */
    val pemEncodedCertificate: String? = builder.pemEncodedCertificate
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetClientCertificateResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetClientCertificateResponse(")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("expirationDate=$expirationDate,")
        append("pemEncodedCertificate=$pemEncodedCertificate,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientCertificateId?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (pemEncodedCertificate?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetClientCertificateResponse

        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (expirationDate != other.expirationDate) return false
        if (pemEncodedCertificate != other.pemEncodedCertificate) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetClientCertificateResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetClientCertificateResponse
        /**
         * The identifier of the client certificate.
         */
        fun clientCertificateId(clientCertificateId: String): FluentBuilder
        /**
         * The timestamp when the client certificate was created.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The description of the client certificate.
         */
        fun description(description: String): FluentBuilder
        /**
         * The timestamp when the client certificate will expire.
         */
        fun expirationDate(expirationDate: Instant): FluentBuilder
        /**
         * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .
         */
        fun pemEncodedCertificate(pemEncodedCertificate: String): FluentBuilder
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the client certificate.
         */
        var clientCertificateId: String?
        /**
         * The timestamp when the client certificate was created.
         */
        var createdDate: Instant?
        /**
         * The description of the client certificate.
         */
        var description: String?
        /**
         * The timestamp when the client certificate will expire.
         */
        var expirationDate: Instant?
        /**
         * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .
         */
        var pemEncodedCertificate: String?
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>?

        fun build(): GetClientCertificateResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientCertificateId: String? = null
        override var createdDate: Instant? = null
        override var description: String? = null
        override var expirationDate: Instant? = null
        override var pemEncodedCertificate: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: GetClientCertificateResponse) : this() {
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.description = x.description
            this.expirationDate = x.expirationDate
            this.pemEncodedCertificate = x.pemEncodedCertificate
            this.tags = x.tags
        }

        override fun build(): GetClientCertificateResponse = GetClientCertificateResponse(this)
        override fun clientCertificateId(clientCertificateId: String): FluentBuilder = apply { this.clientCertificateId = clientCertificateId }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun expirationDate(expirationDate: Instant): FluentBuilder = apply { this.expirationDate = expirationDate }
        override fun pemEncodedCertificate(pemEncodedCertificate: String): FluentBuilder = apply { this.pemEncodedCertificate = pemEncodedCertificate }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
